<?php
$hudson_edge_icon_collections = hudson_edge_return_icon_collections();

$headerandfooterPage = new HudsonEdgeAdminPage(
	"2",
	esc_html__( "Header", 'hudson' ),
	"fa fa-header"
);
$hudson_edge_framework->edgtOptions->addAdminPage(
	"headerandfooter",
	$headerandfooterPage
);

// Header Position

$panel6 = new HudsonEdgePanel(
	esc_html__( "Header Type", 'hudson' ),
	"header_type_panel"
);
$headerandfooterPage->addChild(
	"panel6",
	$panel6
);
$header_type = new HudsonEdgeField(
	"select",
	"header_type",
	"top",
	esc_html__( "Choose Header Type", 'hudson' ),
	esc_html__( "Select the type of header you would like to use", 'hudson' ),
	array(
		"top" => esc_html__( "Top", 'hudson' ),
		"side" => esc_html__( "Side", 'hudson' ),
		"ribbon" => esc_html__( "Ribbon", 'hudson' ),
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"top"    => "#edgtf_vertical_areas_panel,#edgtf_ribbon_menu_panel",
			"side"   => "#edgtf_header_panel,#edgtf_top_menu_panel,#edgtf_header_top_panel,#edgtf_enable_search_panel,#edgtf_enable_side_area_panel,#edgtf_enable_popup_menu_panel,#edgtf_ribbon_menu_panel",
			"ribbon" => "#edgtf_header_panel,#edgtf_top_menu_panel,#edgtf_header_top_panel,#edgtf_enable_search_panel,#edgtf_enable_side_area_panel,#edgtf_enable_popup_menu_panel,#edgtf_vertical_areas_panel"
		),
		"show"       => array(
			"top"    => "#edgtf_header_panel,#edgtf_top_menu_panel,#edgtf_header_top_panel,#edgtf_enable_search_panel,#edgtf_enable_side_area_panel,#edgtf_enable_popup_menu_panel",
			"side"   => "#edgtf_vertical_areas_panel",
			"ribbon" => "#edgtf_ribbon_menu_panel"
		)
	)
);
$panel6->addChild(
	"header_type",
	$header_type
);

// Header

$panel5 = new HudsonEdgePanel(
	esc_html__( "Header", 'hudson' ),
	"header_panel",
	"header_type",
	"",
	array( "side", "ribbon" )
);
$headerandfooterPage->addChild(
	"panel5",
	$panel5
);

$header_in_grid = new HudsonEdgeField(
	"yesno",
	"header_in_grid",
	"yes",
	esc_html__( "Header in Grid", 'hudson' ),
	esc_html__( "Enabling this option will display header content in grid", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_header_padding_container",
		"dependence_show_on_yes" => "#edgtf_header_in_grid_container"
	)
);
$panel5->addChild(
	"header_in_grid",
	$header_in_grid
);

$header_bottom_appearance = new HudsonEdgeField(
	"select",
	"header_bottom_appearance",
	"fixed",
	esc_html__( "Header Type", 'hudson' ),
	esc_html__( "Choose the header layout & behavior", 'hudson' ),
	array(
		"regular" => esc_html__( "Regular", 'hudson' ),
		"fixed" => esc_html__( "Fixed", 'hudson' ),
		"fixed fixed_minimal" => esc_html__( "Fixed Minimal", 'hudson' ),
		"fixed_hiding" => esc_html__( "Fixed Advanced", 'hudson' ),
		"fixed_top_header" => esc_html__( "Fixed Header Top", 'hudson' ),
		"stick" => esc_html__( "Sticky", 'hudson' ),
		"stick menu_bottom" => esc_html__( "Sticky Expanded", 'hudson' ),
		"stick_with_left_right_menu" => esc_html__( "Sticky Divided", 'hudson' ),
		"stick compound" => esc_html__( "Sticky Compound", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"regular"                    => "#edgtf_search_left_sidearea_right_container,#edgtf_menu_vertical_position_for_sticky_container,#edgtf_menu_background_color_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_header_height_scroll,#edgtf_header_height_sticky,#edgtf_header_height_scroll_hidden,#edgtf_header_background_color_scroll,#edgtf_header_grid_background_color_scroll,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_menu_items_position_container,#edgtf_header_background_image_container",
			"fixed"                      => "#edgtf_search_left_sidearea_right_container,#edgtf_menu_vertical_position_for_sticky_container,#edgtf_menu_background_color_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_header_height_sticky,#edgtf_header_height_scroll_hidden,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_menu_items_position_container,#edgtf_header_background_image_container",
			"fixed_hiding"               => "#edgtf_menu_vertical_position_for_sticky_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_menu_position_container,#edgtf_header_height_scroll,#edgtf_header_height_sticky,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_menu_items_position_container,#edgtf_header_background_image_container",
			"stick menu_bottom"          => "#edgtf_search_left_sidearea_right_container,#edgtf_menu_vertical_position_for_sticky_container,#edgtf_menu_position_container,#edgtf_header_height_scroll,#edgtf_header_height_scroll_hidden,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_header_background_color_scroll,#edgtf_header_grid_background_color_scroll,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_menu_items_position_container,#edgtf_header_background_image_container",
			"stick_with_left_right_menu" => "#edgtf_search_left_sidearea_right_container,#edgtf_menu_background_color_container,#edgtf_menu_position_container,#edgtf_header_height_scroll,#edgtf_header_height_scroll_hidden,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_header_background_color_scroll,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_header_background_image_container",
			"stick"                      => "#edgtf_search_left_sidearea_right_container,#edgtf_menu_vertical_position_for_sticky_container,#edgtf_menu_background_color_container,#edgtf_header_height_scroll,#edgtf_header_height_scroll_hidden,#edgtf_header_background_color_scroll,#edgtf_header_grid_background_color_scroll,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_menu_items_position_container,#edgtf_header_background_image_container",
			"fixed_top_header"           => "#edgtf_search_left_sidearea_right_container,#edgtf_menu_vertical_position_for_sticky_container,#edgtf_menu_vertical_position_for_sticky_container,#edgtf_header_height_container,#edgtf_disable_text_shadow_for_sticky_container,#edgtf_menu_background_color_container,#edgtf_menu_position_container,#edgtf_header_top_area_scroll_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_header_height_scroll,#edgtf_header_height_sticky,#edgtf_header_height_scroll_hidden,#edgtf_header_background_color_scroll,#edgtf_header_grid_background_color_scroll,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_menu_items_position_container",
			"fixed fixed_minimal"        => "#edgtf_search_left_sidearea_right_container,#edgtf_menu_vertical_position_for_sticky_container,#edgtf_menu_position_container,#edgtf_menu_background_color_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_header_height_sticky,#edgtf_header_height_scroll_hidden,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_menu_items_position_container,#edgtf_header_background_image_container",
			"stick compound"             => "#edgtf_search_left_sidearea_right_container,#edgtf_menu_vertical_position_for_sticky_container,#edgtf_menu_background_color_container,#edgtf_menu_position_container,#edgtf_header_height_scroll,#edgtf_header_height_scroll_hidden,#edgtf_header_background_color_scroll,#edgtf_header_grid_background_color_scroll,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_menu_items_position_container,#edgtf_header_background_image_container",
		),
		"show"       => array(
			"regular"                    => "#edgtf_header_height_container,#edgtf_menu_position_container,#edgtf_disable_text_shadow_for_sticky_container,#enable_border_for_sticky_container",
			"fixed"                      => "#edgtf_header_height_container,#edgtf_menu_position_container,#edgtf_header_height_scroll,#edgtf_header_background_color_scroll,#edgtf_header_grid_background_color_scroll,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_disable_text_shadow_for_sticky_container,#enable_border_for_sticky_container",
			"stick"                      => "#edgtf_header_height_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_menu_position_container,#edgtf_header_height_sticky,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_disable_text_shadow_for_sticky_container,#enable_border_for_sticky_container",
			"stick menu_bottom"          => "#edgtf_header_height_container,#edgtf_menu_background_color_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_header_height_sticky,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_disable_text_shadow_for_sticky_container,#enable_border_for_sticky_container",
			"stick_with_left_right_menu" => "#edgtf_menu_vertical_position_for_sticky_container,#edgtf_header_height_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_header_height_sticky,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_menu_items_position_container,#edgtf_disable_text_shadow_for_sticky_container,#enable_border_for_sticky_container",
			"fixed_hiding"               => "#edgtf_search_left_sidearea_right_container,#edgtf_header_height_container,#edgtf_menu_background_color_container,#edgtf_header_height_scroll_hidden,#edgtf_header_background_color_scroll,#edgtf_header_grid_background_color_scroll,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_scroll_amount_for_fixed_hiding_container,#edgtf_disable_text_shadow_for_sticky_container,#enable_border_for_sticky_container",
			"fixed_top_header"           => "#edgtf_header_background_image_container",
			"fixed fixed_minimal"        => "#edgtf_header_height_container,#edgtf_header_height_scroll,#edgtf_header_background_color_scroll,#edgtf_header_grid_background_color_scroll,#edgtf_header_background_transparency_scroll,#edgtf_header_grid_background_transparency_scroll,#edgtf_disable_text_shadow_for_sticky_container,#enable_border_for_sticky_container",
			"stick compound"             => "#edgtf_header_height_container,#edgtf_scroll_amount_for_sticky_container,#edgtf_header_height_sticky,#edgtf_header_background_color_sticky,#edgtf_header_grid_background_color_sticky,#edgtf_header_background_transparency_sticky,#edgtf_header_grid_background_transparency_sticky,#edgtf_disable_text_shadow_for_sticky_container,#enable_border_for_sticky_container"
		)
	)
);

$panel5->addChild(
	"header_bottom_appearance",
	$header_bottom_appearance
);

$search_left_sidearea_right_container = new HudsonEdgeContainer(
	"search_left_sidearea_right_container",
	"header_bottom_appearance",
	"",
	array(
		"regular",
		"fixed",
		"fixed_top_header",
		"fixed fixed_minimal",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_top_header",
		"fixed fixed_minimal",
		"stick compound"
	)
);
$panel5->addChild(
	"search_left_sidearea_right_container",
	$search_left_sidearea_right_container
);

$search_left_sidearea_right = new HudsonEdgeField(
	"yesno",
	"search_left_sidearea_right",
	"no",
	esc_html__( "Place Search and Side Area Icons to Separate Sides of Header ", 'hudson' ),
	esc_html__( "Enabling this option will set search icon to left side of header and side area icon to right side of header", 'hudson' )
);
$search_left_sidearea_right_container->addChild(
	"search_left_sidearea_right",
	$search_left_sidearea_right
);

$scroll_amount_for_sticky_container = new HudsonEdgeContainer(
	"scroll_amount_for_sticky_container",
	"header_bottom_appearance",
	"",
	array(
		"regular",
		"fixed",
		"fixed_hiding",
		"fixed_top_header",
		"fixed fixed_minimal"
	)
);
$panel5->addChild(
	"scroll_amount_for_sticky_container",
	$scroll_amount_for_sticky_container
);

$scroll_amount_for_sticky = new HudsonEdgeField(
	"text",
	"scroll_amount_for_sticky",
	"",
	esc_html__( "Scroll Amount for Sticky (px)", 'hudson' ),
	esc_html__( "Enter scroll amount (in pixels) for Sticky Menu to appear", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$scroll_amount_for_sticky_container->addChild(
	"scroll_amount_for_sticky",
	$scroll_amount_for_sticky
);

$hide_initial_sticky = new HudsonEdgeField(
	"yesno",
	"hide_initial_sticky",
	"no",
	esc_html__( "Hide Header Initially", 'hudson' ),
	esc_html__( "Enabling this option will initially hide the header, and it will only be displayed when the user scrolls down the page", 'hudson' )
);
$scroll_amount_for_sticky_container->addChild(
	"hide_initial_sticky",
	$hide_initial_sticky
);

$menu_items_position_container = new HudsonEdgeContainer(
	"menu_items_position_container",
	"header_bottom_appearance",
	"",
	array(
		"regular",
		"fixed",
		"fixed_hiding",
		"fixed_top_header",
		"fixed fixed_minimal",
		"stick",
		"stick menu_bottom",
		"stick compound"
	)
);
$panel5->addChild(
	"menu_items_position_container",
	$menu_items_position_container
);

$menu_items_position = new HudsonEdgeField(
	"select",
	"menu_items_position",
	"",
	esc_html__( "Menu Items Position", 'hudson' ),
	esc_html__( "Choose whether you would like the menu items to start from center of screen and extend outwards, or from the edges of the grid and extend inward", 'hudson' ),
	array(
		"from_center" => esc_html__( "From Center", 'hudson' ),
		"from_edges" => esc_html__( "From Edges of Grid", 'hudson' )
	)
);
$menu_items_position_container->addChild(
	"menu_items_position",
	$menu_items_position
);

$menu_vertical_position_for_sticky_container = new HudsonEdgeContainer(
	"menu_vertical_position_for_sticky_container",
	"header_bottom_appearance",
	"",
	array(
		"regular",
		"fixed",
		"fixed_hiding",
		"fixed_top_header",
		"fixed fixed_minimal",
		"stick menu_bottom",
		"stick compound",
		"stick"
	)
);
$panel5->addChild(
	"menu_vertical_position_for_sticky_container",
	$menu_vertical_position_for_sticky_container
);

$menu_vertical_position_for_sticky = new HudsonEdgeField(
	"select",
	"menu_vertical_position_for_sticky",
	"",
	esc_html__( "Menu Vertical Alignment", 'hudson' ),
	esc_html__( "Choose the vertical alignment for the menu in the Sticky Divided header", 'hudson' ),
	array(
		"default" => esc_html__( "Default", 'hudson' ),
		"bottom" => esc_html__( "Bottom", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"default" => "#edgtf_menu_bottom_position_container"
		),
		"show"       => array(
			"bottom" => "#edgtf_menu_bottom_position_container"
		)
	)
);
$menu_vertical_position_for_sticky_container->addChild(
	"menu_vertical_position_for_sticky",
	$menu_vertical_position_for_sticky
);

$menu_bottom_position_container = new HudsonEdgeContainer(
	"menu_bottom_position_container",
	"menu_vertical_position_for_sticky",
	"",
	array( "default" )
);
$panel5->addChild(
	"menu_bottom_position_container",
	$menu_bottom_position_container
);

$menu_bottom_position = new HudsonEdgeField(
	"text",
	"menu_bottom_position",
	"",
	esc_html__( "Menu Bottom Offset (px)", 'hudson' ),
	esc_html__( "Enter the amount of pixels you would like to move the menu from bottom of header", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$menu_bottom_position_container->addChild(
	"menu_bottom_position",
	$menu_bottom_position
);

$scroll_amount_for_fixed_hiding_container = new HudsonEdgeContainer(
	"scroll_amount_for_fixed_hiding_container",
	"header_bottom_appearance",
	"",
	array(
		"regular",
		"fixed",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_top_header",
		"fixed fixed_minimal",
		"stick compound"
	)
);
$panel5->addChild(
	"scroll_amount_for_fixed_hiding_container",
	$scroll_amount_for_fixed_hiding_container
);
$scroll_amount_for_fixed_hiding = new HudsonEdgeField(
	"text",
	"scroll_amount_for_fixed_hiding",
	"",
	esc_html__( "Scroll Amount (px)", 'hudson' ),
	esc_html__( "Enter scroll amount (in pixels) for menu to hide", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$scroll_amount_for_fixed_hiding_container->addChild(
	"scroll_amount_for_fixed_hiding",
	$scroll_amount_for_fixed_hiding
);

$menu_position_container = new HudsonEdgeContainer(
	"menu_position_container",
	"header_bottom_appearance",
	"",
	array(
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_hiding",
		"fixed_top_header",
		"stick compound"
	)
);
$panel5->addChild(
	"menu_position_container",
	$menu_position_container
);

$menu_position = new HudsonEdgeField(
	"select",
	"menu_position",
	"",
	esc_html__( "Menu Position", 'hudson' ),
	esc_html__( "Choose a menu position (default is right alignment)", 'hudson' ),
	array(
		"-1" => esc_html__( "Right", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' )
	)
);
$menu_position_container->addChild(
	"menu_position",
	$menu_position
);

$center_logo_image = new HudsonEdgeField(
	"yesno",
	"center_logo_image",
	"no",
	esc_html__( "Center Logo", 'hudson' ),
	esc_html__( "Enabling this option will center logo and position it above menu", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_center_logo_image_container"
	)
);
$menu_position_container->addChild(
	"center_logo_image",
	$center_logo_image
);

$center_logo_image_container = new HudsonEdgeContainer(
	"center_logo_image_container",
	"center_logo_image",
	"no"
);
$menu_position_container->addChild(
	"center_logo_image_container",
	$center_logo_image_container
);

$search_left_sidearea_right_regular = new HudsonEdgeField(
	"yesno",
	"search_left_sidearea_right_regular",
	"no",
	esc_html__( "Place Search and Side Area Icons to Separate Sides of Header ", 'hudson' ),
	esc_html__( "Enabling this option will set search icon to left side of header and side area icon to right side of header", 'hudson' )
);
$center_logo_image_container->addChild(
	"search_left_sidearea_right_regular",
	$search_left_sidearea_right_regular
);

$enable_border_top_bottom_menu = new HudsonEdgeField(
	"yesno",
	"enable_border_top_bottom_menu",
	"no",
	esc_html__( "Enable Top/Bottom Border in Menu", 'hudson' ),
	"",
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_menu_border_container"
	)
);
$center_logo_image_container->addChild(
	"enable_border_top_bottom_menu",
	$enable_border_top_bottom_menu
);

$menu_border_container = new HudsonEdgeContainer(
	"menu_border_container",
	"enable_border_top_bottom_menu",
	"no"
);
$center_logo_image_container->addChild(
	"menu_border_container",
	$menu_border_container
);

$color_border_top_bottom_menu = new HudsonEdgeField(
	"color",
	"color_border_top_bottom_menu",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose a color for the top/bottom border in menu.", 'hudson' )
);
$menu_border_container->addChild(
	"color_border_top_bottom_menu",
	$color_border_top_bottom_menu
);

$disable_text_shadow_for_sticky_container = new HudsonEdgeContainer(
	"disable_text_shadow_for_sticky_container",
	"header_bottom_appearance",
	"",
	array( "fixed_top_header" )
);
$panel5->addChild(
	"disable_text_shadow_for_sticky_container",
	$disable_text_shadow_for_sticky_container
);

$disable_text_shadow_for_sticky = new HudsonEdgeField(
	"yesno",
	"disable_text_shadow_for_sticky",
	"yes",
	esc_html__( "Disable Shadow For Scrolled Header", 'hudson' ),
	esc_html__( "Enabling this option will display text shadow for scrolled/sticky header", 'hudson' )
);
$disable_text_shadow_for_sticky_container->addChild(
	"disable_text_shadow_for_sticky",
	$disable_text_shadow_for_sticky
);

$enable_border_for_sticky_container = new HudsonEdgeContainer(
	"enable_border_for_sticky_container",
	"header_bottom_appearance",
	"",
	array( "fixed_top_header" )
);
$panel5->addChild(
	"enable_border_for_sticky_container",
	$enable_border_for_sticky_container
);

$enable_border_for_sticky = new HudsonEdgeField(
	"yesno",
	"enable_border_for_sticky",
	"no",
	esc_html__( "Enable Border For Scrolled Header", 'hudson' ),
	esc_html__( "Enabling this option will display border for scrolled/sticky header", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_border_bottom_color_for_sticky_container"
	)
);
$enable_border_for_sticky_container->addChild(
	"enable_border_for_sticky",
	$enable_border_for_sticky
);

$enable_border_bottom_color_for_sticky_container = new HudsonEdgeContainer(
	"enable_border_bottom_color_for_sticky_container",
	"enable_border_for_sticky",
	"no"
);
$panel5->addChild(
	"enable_border_color_for_sticky_container",
	$enable_border_bottom_color_for_sticky_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Border Style", 'hudson' ),
	esc_html__( "Choose style for border for scrolled/sticky header", 'hudson' )
);
$enable_border_bottom_color_for_sticky_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$border_bottom_color_for_sticky = new HudsonEdgeField(
	"colorsimple",
	"border_bottom_color_for_sticky",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"border_bottom_color_for_sticky",
	$border_bottom_color_for_sticky
);

$border_bottom_width_for_sticky = new HudsonEdgeField(
	"textsimple",
	"border_bottom_width_for_sticky",
	"",
	esc_html__( "Border Width", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"border_bottom_width_for_sticky",
	$border_bottom_width_for_sticky
);

$header_height_container = new HudsonEdgeContainerNoStyle(
	"header_height_container",
	"header_bottom_appearance",
	"",
	array( "fixed_top_header" )
);
$panel5->addChild(
	"header_height_container",
	$header_height_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Header Height", 'hudson' ),
	esc_html__( "Enter header height in pixels", 'hudson' )
);
$header_height_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$header_height = new HudsonEdgeField(
	"textsimple",
	"header_height",
	"",
	esc_html__( "Initial (px)", 'hudson' ),
	esc_html__( "Initial header (px)", 'hudson' )
);
$row1->addChild(
	"header_height",
	$header_height
);

$header_height_scroll = new HudsonEdgeField(
	"textsimple",
	"header_height_scroll",
	"",
	esc_html__( "After Scroll (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_hiding",
		"fixed_top_header",
		"stick compound"
	)
);
$row1->addChild(
	"header_height_scroll",
	$header_height_scroll
);

$header_height_sticky = new HudsonEdgeField(
	"textsimple",
	"header_height_sticky",
	"",
	esc_html__( "After Scroll (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"fixed",
		"fixed_hiding",
		"fixed_top_header",
		"fixed fixed_minimal"
	)
);
$row1->addChild(
	"header_height_sticky",
	$header_height_sticky
);

$header_height_scroll_hidden = new HudsonEdgeField(
	"textsimple",
	"header_height_scroll_hidden",
	"",
	esc_html__( "After Scroll (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"fixed",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_top_header",
		"fixed fixed_minimal",
		"stick compound"
	)
);
$row1->addChild(
	"header_height_scroll_hidden",
	$header_height_scroll_hidden
);

$header_padding_container = new HudsonEdgeContainer(
	"header_padding_container",
	"header_in_grid",
	"yes"
);
$panel5->addChild(
	"header_padding_container",
	$header_padding_container
);

$header_left_padding = new HudsonEdgeField(
	"text",
	"header_left_padding",
	"",
	esc_html__( "Header Left Padding", 'hudson' ),
	esc_html__( "Set left padding for header bottom appearance in px or % (default value is 45px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_padding_container->addChild(
	"header_left_padding",
	$header_left_padding
);

$header_right_padding = new HudsonEdgeField(
	"text",
	"header_right_padding",
	"",
	esc_html__( "Header Right Padding", 'hudson' ),
	esc_html__( "Set right padding for header bottom appearance in px or % (default value is 45px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_padding_container->addChild(
	"header_right_padding",
	$header_right_padding
);

$header_style = new HudsonEdgeField(
	"select",
	"header_style",
	"",
	esc_html__( "Header Skin", 'hudson' ),
	esc_html__( "Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style", 'hudson' ),
	array(
		"-1"    => "",
		"light" => esc_html__( "Light", 'hudson' ),
		"dark" => esc_html__( "Dark", 'hudson' )
	)
);
$panel5->addChild(
	"header_style",
	$header_style
);

$enable_header_style_on_scroll = new HudsonEdgeField(
	"yesno",
	"enable_header_style_on_scroll",
	"no",
	esc_html__( "Enable Header Style on Scroll", 'hudson' ),
	esc_html__( "Enabling this option, header will change style depending on row settings for dark/light style", 'hudson' )
);
$panel5->addChild(
	"enable_header_style_on_scroll",
	$enable_header_style_on_scroll
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Header Background Color", 'hudson' ),
	esc_html__( "Choose a background color for header area", 'hudson' )
);
$panel5->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$header_background_color = new HudsonEdgeField(
	"colorsimple",
	"header_background_color",
	"",
	esc_html__( "Initial", 'hudson' ),
	""
);
$row1->addChild(
	"header_background_color",
	$header_background_color
);

$header_background_color_scroll = new HudsonEdgeField(
	"colorsimple",
	"header_background_color_scroll",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	"",
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_top_header",
		"stick compound"
	)
);
$row1->addChild(
	"header_background_color_scroll",
	$header_background_color_scroll
);

$header_background_color_sticky = new HudsonEdgeField(
	"colorsimple",
	"header_background_color_sticky",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	"",
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"fixed",
		"fixed_hiding",
		"fixed_top_header",
		"fixed fixed_minimal"
	)
);
$row1->addChild(
	"header_background_color_sticky",
	$header_background_color_sticky
);

$header_background_image_container = new HudsonEdgeContainer(
	"header_background_image_container",
	"header_bottom_appearance",
	"",
	array(
		"regular",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed",
		"stick compound",
		"fixed_hiding",
		"fixed fixed_minimal"
	)
);
$panel5->addChild(
	"header_background_image_container",
	$header_background_image_container
);

$group88 = new HudsonEdgeGroup(
	esc_html__( "Header Background Image", 'hudson' ),
	esc_html__( "Choose an image for the header background", 'hudson' )
);
$header_background_image_container->addChild(
	"group88",
	$group88
);

$row1 = new HudsonEdgeRow();
$group88->addChild(
	"row1",
	$row1
);

$header_background_image = new HudsonEdgeField(
	"imagesimple",
	"header_background_image"
);
$row1->addChild(
	"header_background_image",
	$header_background_image
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Header Transparency", 'hudson' ),
	esc_html__( "Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$panel5->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$header_background_transparency_initial = new HudsonEdgeField(
	"textsimple",
	"header_background_transparency_initial",
	"",
	esc_html__( "Initial", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"header_background_transparency_initial",
	$header_background_transparency_initial
);

$header_background_transparency_scroll = new HudsonEdgeField(
	"textsimple",
	"header_background_transparency_scroll",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_top_header",
		"stick compound"
	)
);
$row1->addChild(
	"header_background_transparency_scroll",
	$header_background_transparency_scroll
);

$header_background_transparency_sticky = new HudsonEdgeField(
	"textsimple",
	"header_background_transparency_sticky",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"fixed",
		"fixed_hiding",
		"fixed_top_header",
		"fixed fixed_minimal"
	)
);
$row1->addChild(
	"header_background_transparency_sticky",
	$header_background_transparency_sticky
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Header Background Pattern", 'hudson' ),
	esc_html__( "Choose a pattern for the header background", 'hudson' )
);
$panel5->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);

$header_pattern_image_initial = new HudsonEdgeField(
	"imagesimple",
	"header_pattern_image_initial",
	"",
	esc_html__( "Initial", 'hudson' ),
	""
);
$row1->addChild(
	"header_pattern_image_initial",
	$header_pattern_image_initial
);

$header_pattern_image_scroll = new HudsonEdgeField(
	"imagesimple",
	"header_pattern_image_scroll",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	""
);
$row1->addChild(
	"header_pattern_image_scroll",
	$header_pattern_image_scroll
);

$header_in_grid_container = new HudsonEdgeContainerNoStyle(
	'header_in_grid_container',
	'header_in_grid',
	'no'
);
$panel5->addChild(
	'header_in_grid_container',
	$header_in_grid_container
);

$group6 = new HudsonEdgeGroup(
	esc_html__( 'Header Grid Content Background Color', 'hudson' ),
	esc_html__( 'Choose a background color for header grid content area', 'hudson' )
);
$header_in_grid_container->addChild(
	'group6',
	$group6
);

$row1 = new HudsonEdgeRow();
$group6->addChild(
	'row1',
	$row1
);

$header_grid_background_color = new HudsonEdgeField(
	"colorsimple",
	"header_grid_background_color",
	"",
	esc_html__( "Initial", 'hudson' ),
	""
);
$row1->addChild(
	"header_grid_background_color",
	$header_grid_background_color
);

$header_grid_background_color_scroll = new HudsonEdgeField(
	"colorsimple",
	"header_grid_background_color_scroll",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	"",
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_top_header",
		"stick compound"
	)
);
$row1->addChild(
	"header_grid_background_color_scroll",
	$header_grid_background_color_scroll
);

$header_grid_background_color_sticky = new HudsonEdgeField(
	"colorsimple",
	"header_grid_background_color_sticky",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	"",
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"fixed",
		"fixed_hiding",
		"fixed_top_header",
		"fixed fixed_minimal"
	)
);
$row1->addChild(
	"header_grid_background_color_sticky",
	$header_grid_background_color_sticky
);

$group7 = new HudsonEdgeGroup(
	esc_html__( 'Header Grid Content Transparency', 'hudson' ),
	esc_html__( 'Choose a transparency for the header background color (0 = fully transparent, 1 = opaque', 'hudson' )
);
$header_in_grid_container->addChild(
	'group7',
	$group7
);

$row2 = new HudsonEdgeRow();
$group7->addChild(
	"row2",
	$row2
);

$header_grid_background_transparency_initial = new HudsonEdgeField(
	"textsimple",
	"header_grid_background_transparency_initial",
	"",
	esc_html__( "Initial", 'hudson' ),
	""
);
$row2->addChild(
	"header_grid_background_transparency_initial",
	$header_grid_background_transparency_initial
);

$header_grid_background_transparency_scroll = new HudsonEdgeField(
	"textsimple",
	"header_grid_background_transparency_scroll",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	"",
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"stick",
		"stick menu_bottom",
		"stick_with_left_right_menu",
		"fixed_top_header",
		"stick compound"
	)
);
$row2->addChild(
	"header_grid_background_transparency_scroll",
	$header_grid_background_transparency_scroll
);

$header_grid_background_transparency_sticky = new HudsonEdgeField(
	"textsimple",
	"header_grid_background_transparency_sticky",
	"",
	esc_html__( "After Scroll", 'hudson' ),
	"",
	array(),
	array(),
	"header_bottom_appearance",
	array(
		"regular",
		"fixed",
		"fixed_hiding",
		"fixed_top_header",
		"fixed fixed_minimal"
	)
);
$row2->addChild(
	"header_grid_background_transparency_sticky",
	$header_grid_background_transparency_sticky
);

$group8 = new HudsonEdgeGroup(
	esc_html__( 'Header in Grid Padding', 'hudson' ),
	esc_html__( 'Left and right padding for header in grid', 'hudson' )
);
$header_in_grid_container->addChild(
	'group8',
	$group8
);

$row3 = new HudsonEdgeRow();
$group8->addChild(
	'row3',
	$row3
);

$header_in_grid_padding_left = new HudsonEdgeField(
	'textsimple',
	'header_in_grid_padding_left',
	'',
	esc_html__( 'Left (px)', 'hudson' ),
	''
);
$row3->addChild(
	'header_in_grid_padding_left',
	$header_in_grid_padding_left
);

$header_in_grid_padding_right = new HudsonEdgeField(
	'textsimple',
	'header_in_grid_padding_right',
	'',
	esc_html__( 'Right (px)', 'hudson' ),
	''
);
$row3->addChild(
	'header_in_grid_padding_right',
	$header_in_grid_padding_right
);

$enable_header_top_border = new HudsonEdgeField(
	"yesno",
	"enable_header_top_border",
	"no",
	esc_html__( "Enable Header Top Border", 'hudson' ),
	"",
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_header_top_border_container"
	)
);
$panel5->addChild(
	"enable_header_top_border",
	$enable_header_top_border
);

$header_top_border_container = new HudsonEdgeContainer(
	"header_top_border_container",
	"enable_header_top_border",
	"no"
);
$panel5->addChild(
	"header_top_border_container",
	$header_top_border_container
);

$header_top_border_width = new HudsonEdgeField(
	"text",
	"header_top_border_width",
	"",
	esc_html__( "Header Top Border Width (px)", 'hudson' ),
	esc_html__( "Choose a width for the header top border. Note: If width has not been set, border top will not be displayed", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_top_border_container->addChild(
	"header_top_border_width",
	$header_top_border_width
);

$header_top_border_color = new HudsonEdgeField(
	"color",
	"header_top_border_color",
	"",
	esc_html__( "Header Top Border Color", 'hudson' ),
	esc_html__( "Choose a color for the header top border. ", 'hudson' )
);
$header_top_border_container->addChild(
	"header_top_border_color",
	$header_top_border_color
);

$header_top_border_transparency = new HudsonEdgeField(
	"text",
	"header_top_border_transparency",
	"",
	esc_html__( "Header Top Border Transparency", 'hudson' ),
	esc_html__( "Choose a transparency for the header border color (0 = fully transparent, 1 = opaque). Note: Works only if Header top Border Color is filled", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_top_border_container->addChild(
	"header_top_border_transparency",
	$header_top_border_transparency
);

$enable_header_bottom_border = new HudsonEdgeField(
	"yesno",
	"enable_header_bottom_border",
	"no",
	esc_html__( "Enable Header Bottom Border", 'hudson' ),
	"",
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_header_bottom_border_container"
	)
);
$panel5->addChild(
	"enable_header_bottom_border",
	$enable_header_bottom_border
);

$header_bottom_border_container = new HudsonEdgeContainer(
	"header_bottom_border_container",
	"enable_header_bottom_border",
	"no"
);
$panel5->addChild(
	"header_bottom_border_container",
	$header_bottom_border_container
);

$header_bottom_border_width = new HudsonEdgeField(
	"text",
	"header_bottom_border_width",
	"",
	esc_html__( "Header Bottom Border Width (px)", 'hudson' ),
	esc_html__( "Choose a width for the header bottom  border. Note: If width has not been set, border bottom will not be displayed", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_bottom_border_container->addChild(
	"header_bottom_border_width",
	$header_bottom_border_width
);

$header_bottom_border_color = new HudsonEdgeField(
	"color",
	"header_bottom_border_color",
	"",
	esc_html__( "Header Bottom Border Color", 'hudson' ),
	esc_html__( "Choose a color for the header bottom border.", 'hudson' )
);
$header_bottom_border_container->addChild(
	"header_bottom_border_color",
	$header_bottom_border_color
);

$header_botom_border_transparency = new HudsonEdgeField(
	"text",
	"header_botom_border_transparency",
	"",
	esc_html__( "Header Bottom Border Transparency", 'hudson' ),
	esc_html__( "Choose a transparency for the header border color (0 = fully transparent, 1 = opaque). Note: Works only if Header Bottom Border Color is filled", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_bottom_border_container->addChild(
	"header_botom_border_transparency",
	$header_botom_border_transparency
);

$header_botom_border_in_grid = new HudsonEdgeField(
	"yesno",
	"header_botom_border_in_grid",
	"no",
	esc_html__( "Enable Header Bottom Border in Grid", 'hudson' ),
	esc_html__( "Enabling this option will set header border bottom width in grid", 'hudson' )
);
$header_bottom_border_container->addChild(
	"header_botom_border_in_grid",
	$header_botom_border_in_grid
);

// Menu

$panel4 = new HudsonEdgePanel(
	esc_html__( "Top Menu", 'hudson' ),
	"top_menu_panel",
	"header_type",
	"",
	array( "side", "ribbon" )
);
$headerandfooterPage->addChild(
	"panel4",
	$panel4
);

$menu_background_color_container = new HudsonEdgeContainer(
	"menu_background_color_container",
	"header_bottom_appearance",
	"",
	array(
		"regular",
		"fixed",
		"stick",
		"stick_with_left_right_menu",
		"fixed_top_header",
		"fixed fixed_minimal",
		"stick compound"
	)
);
$panel4->addChild(
	"menu_background_color_container",
	$menu_background_color_container
);

$menu_background_color = new HudsonEdgeField(
	"color",
	"menu_background_color",
	"",
	esc_html__( "Background Color of 1st Level Menu", 'hudson' ),
	esc_html__( "Choose a color for the menu background (works only for Fixed Advanced and Sticky Expanded header types)", 'hudson' )
);
$menu_background_color_container->addChild(
	"menu_background_color",
	$menu_background_color
);

$enable_menu_top_bottom_border = new HudsonEdgeField(
	"yesno",
	"enable_menu_top_bottom_border",
	"no",
	esc_html__( "Enable Top/Bottom Borders in 1st Level Menu", 'hudson' ),
	esc_html__( "Enabling this option will display top and bottom borders around 1st level menu (works only for Fixed Advanced and Sticky Expanded header types)", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_menu_top_bottom_border_container"
	)
);
$menu_background_color_container->addChild(
	"enable_menu_top_bottom_border",
	$enable_menu_top_bottom_border
);
$menu_top_bottom_border_container = new HudsonEdgeContainer(
	"menu_top_bottom_border_container",
	"enable_menu_top_bottom_border",
	"no"
);
$menu_background_color_container->addChild(
	"menu_top_bottom_border_container",
	$menu_top_bottom_border_container
);
$color_menu_top_bottom_border = new HudsonEdgeField(
	"color",
	"color_menu_top_bottom_border",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose a color for the top/bottom border in 1st level menu.", 'hudson' )
);
$menu_top_bottom_border_container->addChild(
	"color_menu_top_bottom_border",
	$color_menu_top_bottom_border
);

$enable_menu_wide_background = new HudsonEdgeField(
	"yesno",
	"enable_menu_wide_background",
	"no",
	esc_html__( "Enable wide background in 1st Level Menu", 'hudson' ),
	esc_html__( "Enabling this option will show wide background or borders in 1st level menu (works only for Fixed Advanced and Sticky Expanded header types)", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => ""
	)
);
$menu_background_color_container->addChild(
	"enable_menu_wide_background",
	$enable_menu_wide_background
);

$menu_item_icon_position = new HudsonEdgeField(
	"select",
	"menu_item_icon_position",
	"left",
	esc_html__( "Icon Position in 1st Level Menu", 'hudson' ),
	esc_html__( "Choose position of icon selected in Appearance->Menu->Menu Structure", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"top" => esc_html__( "Top", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"left" => "#edgtf_menu_item_icon_position_container"
		),
		"show"       => array(
			"top" => "#edgtf_menu_item_icon_position_container"
		)
	)
);
$panel4->addChild(
	"menu_item_icon_position",
	$menu_item_icon_position
);
$menu_item_icon_position_container = new HudsonEdgeContainer(
	"menu_item_icon_position_container",
	"menu_item_icon_position",
	"left"
);
$panel4->addChild(
	"menu_item_icon_position_container",
	$menu_item_icon_position_container
);

$menu_item_icon_size = new HudsonEdgeField(
	"text",
	"menu_item_icon_size",
	"",
	esc_html__( "Icon Size (px)", 'hudson' ),
	esc_html__( "Enter icon size in pixels", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$menu_item_icon_position_container->addChild(
	"menu_item_icon_size",
	$menu_item_icon_size
);

$menu_item_style = new HudsonEdgeField(
	"select",
	"menu_item_style",
	"small_item",
	esc_html__( "Item Height in 1st Level Menu", 'hudson' ),
	esc_html__( "Choose menu item height", 'hudson' ),
	array(
		"small_item" => esc_html__( "Small", 'hudson' ),
		"large_item" => esc_html__( "Big", 'hudson' )
	)
);
$panel4->addChild(
	"menu_item_style",
	$menu_item_style
);

$enable_manu_item_border = new HudsonEdgeField(
	"yesno",
	"enable_manu_item_border",
	"no",
	esc_html__( "Enable 1st Level Menu Item Borders", 'hudson' ),
	esc_html__( "Enabling this option will display border around menu items", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_menu_item_border_container"
	)
);
$panel4->addChild(
	"enable_manu_item_border",
	$enable_manu_item_border
);

$menu_item_border_container = new HudsonEdgeContainer(
	"menu_item_border_container",
	"enable_manu_item_border",
	"no"
);
$panel4->addChild(
	"menu_item_border_container",
	$menu_item_border_container
);

$menu_item_border_style = new HudsonEdgeField(
	"select",
	"menu_item_border_style",
	"",
	esc_html__( "Menu Item Border", 'hudson' ),
	esc_html__( "Visible only if border width and one of the border color fields are filled.", 'hudson' ),
	array(
		"all_borders" => esc_html__( "All Borders", 'hudson' ),
		"top_bottom_borders" => esc_html__( "Top/Bottom Borders", 'hudson' ),
		"right_border" => esc_html__( "Right Border", 'hudson' ),
		"bottom_border" => esc_html__( "Bottom Border", 'hudson' ),
		"bottom_border_double" => esc_html__( "Bottom Double Borders", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"bottom_border_double" => "#edgtf_menu_item_border_width_container"
		),
		"show"       => array(
			"all_borders"        => "#edgtf_menu_item_border_width_container",
			"top_bottom_borders" => "#edgtf_menu_item_border_width_container",
			"right_border"       => "#edgtf_menu_item_border_width_container",
			"bottom_border"      => "#edgtf_menu_item_border_width_container"
		)
	)
);
$menu_item_border_container->addChild(
	"menu_item_border_style",
	$menu_item_border_style
);

$menu_item_border_width_container = new HudsonEdgeContainer(
	"menu_item_border_width_container",
	"menu_item_border_style",
	"bottom_border_double"
);
$menu_item_border_container->addChild(
	"menu_item_border_width_container",
	$menu_item_border_width_container
);
$menu_item_border_width = new HudsonEdgeField(
	"text",
	"menu_item_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "Enter border width (in pixels) ", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$menu_item_border_width_container->addChild(
	"menu_item_border_width",
	$menu_item_border_width
);

$menu_item_border_radius = new HudsonEdgeField(
	"text",
	"menu_item_border_radius",
	"",
	esc_html__( "Border Radius", 'hudson' ),
	esc_html__( "Enter border radius (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$menu_item_border_width_container->addChild(
	"menu_item_border_radius",
	$menu_item_border_radius
);

$menu_item_border_style_style = new HudsonEdgeField(
	"select",
	"menu_item_border_style_style",
	"solid",
	esc_html__( "Border Style", 'hudson' ),
	esc_html__( "Choose border style", 'hudson' ),
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' )
	)
);
$menu_item_border_width_container->addChild(
	"menu_item_border_style_style",
	$menu_item_border_style_style
);
$group1 = new HudsonEdgeGroup(
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose a color for border", 'hudson' )
);
$menu_item_border_container->addChild(
	"group1",
	$group1
);
$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);
$menu_item_border_color = new HudsonEdgeField(
	"colorsimple",
	"menu_item_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border color", 'hudson' )
);
$row1->addChild(
	"menu_item_border_color",
	$menu_item_border_color
);
$menu_item_hover_border_color = new HudsonEdgeField(
	"colorsimple",
	"menu_item_hover_border_color",
	"",
	esc_html__( "Border Hover Color", 'hudson' ),
	esc_html__( "Choose border color on menu item hover", 'hudson' )
);
$row1->addChild(
	"menu_item_hover_border_color",
	$menu_item_hover_border_color
);
$menu_item_active_border_color = new HudsonEdgeField(
	"colorsimple",
	"menu_item_active_border_color",
	"",
	esc_html__( "Border Active Color", 'hudson' ),
	esc_html__( "Choose border color on active menu item", 'hudson' )
);
$row1->addChild(
	"menu_item_active_border_color",
	$menu_item_active_border_color
);

$enable_menu_item_separators = new HudsonEdgeField(
	"yesno",
	"enable_menu_item_separators",
	"no",
	esc_html__( "Enable 1st Level Menu Item Separators", 'hudson' ),
	esc_html__( "Enabling this option will display separators between menu items", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_menu_item_separators_container"
	)
);
$panel4->addChild(
	"enable_menu_item_separators",
	$enable_menu_item_separators
);
$menu_item_separators_container = new HudsonEdgeContainer(
	"menu_item_separators_container",
	"enable_menu_item_separators",
	"no"
);
$panel4->addChild(
	"menu_item_separators_container",
	$menu_item_separators_container
);
$group1 = new HudsonEdgeGroup(
	esc_html__( "Menu Item Separators Style", 'hudson' ),
	""
);
$menu_item_separators_container->addChild(
	"group1",
	$group1
);
$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);
$menu_item_separators_color = new HudsonEdgeField(
	"colorsimple",
	"menu_item_separators_color",
	"",
	esc_html__( "Separators Color", 'hudson' ),
	esc_html__( "Enter separators color", 'hudson' )
);
$row1->addChild(
	"menu_item_separators_color",
	$menu_item_separators_color
);

$enable_menu_item_text_decoration = new HudsonEdgeField(
	"yesno",
	"enable_menu_item_text_decoration",
	"no",
	esc_html__( "Enable 1st Level Menu Item Text Decoration", 'hudson' ),
	esc_html__( "Enable this option and choose a text decoration for menu items in first level", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_menu_item_text_decoration_container"
	)
);
$panel4->addChild(
	"enable_menu_item_text_decoration",
	$enable_menu_item_text_decoration
);

$menu_item_text_decoration_container = new HudsonEdgeContainer(
	"menu_item_text_decoration_container",
	"enable_menu_item_text_decoration",
	"no"
);
$panel4->addChild(
	"menu_item_text_decoration_container",
	$menu_item_text_decoration_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Menu Item Text Decoration", 'hudson' ),
	""
);
$menu_item_text_decoration_container->addChild(
	"group1",
	$group1
);
$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$menu_item_text_decoration_style = new HudsonEdgeField(
	"selectsimple",
	"menu_item_text_decoration_style",
	"none",
	esc_html__( "Hover Item Text Decoration", 'hudson' ),
	esc_html__( "Choose text decoration type for hover menu items", 'hudson' ),
	array(
		"none" => esc_html__( "None", 'hudson' ),
		"underline" => esc_html__( "Underline", 'hudson' ),
		"line-through" => esc_html__( "Line-through", 'hudson' ),
		"overline" => esc_html__( "Overline", 'hudson' )
	)
);
$row1->addChild(
	"menu_item_text_decoration_style",
	$menu_item_text_decoration_style
);

$menu_item_active_text_decoration_style = new HudsonEdgeField(
	"selectsimple",
	"menu_item_active_text_decoration_style",
	"none",
	esc_html__( "Active Item Text Decoration", 'hudson' ),
	esc_html__( "Choose text decoration type for active menu items", 'hudson' ),
	array(
		"none" => esc_html__( "None", 'hudson' ),
		"underline" => esc_html__( "Underline", 'hudson' ),
		"line-through" => esc_html__( "Line-through", 'hudson' ),
		"overline" => esc_html__( "Overline", 'hudson' )
	)
);
$row1->addChild(
	"menu_item_active_text_decoration_style",
	$menu_item_active_text_decoration_style
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Main Dropdown Menu", 'hudson' ),
	esc_html__( "Choose a color and transparency for the main menu background (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$panel4->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$dropdown_background_color = new HudsonEdgeField(
	"colorsimple",
	"dropdown_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"dropdown_background_color",
	$dropdown_background_color
);

$dropdown_background_transparency = new HudsonEdgeField(
	"textsimple",
	"dropdown_background_transparency",
	"",
	esc_html__( "Transparency", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"dropdown_background_transparency",
	$dropdown_background_transparency
);

$dropdown_separator_color = new HudsonEdgeField(
	"colorsimple",
	"dropdown_separator_color",
	"",
	esc_html__( "Item Bottom Separator Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"dropdown_separator_color",
	$dropdown_separator_color
);

$dropdown_vertical_separator_color = new HudsonEdgeField(
	"colorsimple",
	"dropdown_vertical_separator_color",
	"",
	esc_html__( "Item Vertical Separator Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"dropdown_vertical_separator_color",
	$dropdown_vertical_separator_color
);

$row2 = new HudsonEdgeRow();
$group1->addChild(
	"row2",
	$row2
);

$enable_dropdown_separator_full_width = new HudsonEdgeField(
	"yesnosimple",
	"enable_dropdown_separator_full_width",
	"no",
	esc_html__( "Item Separator Full Width", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"enable_dropdown_separator_full_width",
	$enable_dropdown_separator_full_width
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Main Dropdown Menu Padding", 'hudson' ),
	esc_html__( "Choose a top/bottom padding for dropdown menu", 'hudson' )
);
$panel4->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$dropdown_top_padding = new HudsonEdgeField(
	"textsimple",
	"dropdown_top_padding",
	"",
	esc_html__( "Top Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"dropdown_top_padding",
	$dropdown_top_padding
);

$dropdown_bottom_padding = new HudsonEdgeField(
	"textsimple",
	"dropdown_bottom_padding",
	"",
	esc_html__( "Bottom Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"dropdown_bottom_padding",
	$dropdown_bottom_padding
);

$menu_dropdown_appearance = new HudsonEdgeField(
	"select",
	"menu_dropdown_appearance",
	"default",
	esc_html__( "Main Dropdown Menu Appearance", 'hudson' ),
	esc_html__( "Choose appearance for dropdown menu", 'hudson' ),
	array(
		"default" => esc_html__( "Default", 'hudson' ),
		"slide_from_bottom" => esc_html__( "Slide From Bottom", 'hudson' ),
		"slide_from_top" => esc_html__( "Slide From Top", 'hudson' ),
		"animate_height" => esc_html__( "Animate Height", 'hudson' ),
		"slide_from_left" => esc_html__( "Slide From Left", 'hudson' )
	)
);
$panel4->addChild(
	"menu_dropdown_appearance",
	$menu_dropdown_appearance
);

$dropdown_top_position = new HudsonEdgeField(
	"text",
	"dropdown_top_position",
	"",
	esc_html__( "Dropdown position", 'hudson' ),
	esc_html__( "Enter value in percentage of entire header height", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel4->addChild(
	"dropdown_top_position",
	$dropdown_top_position
);

$enable_dropdown_menu_item_icon = new HudsonEdgeField(
	"yesno",
	"enable_dropdown_menu_item_icon",
	"yes",
	esc_html__( "Enable Arrow Icon for Dropdown Menu", 'hudson' ),
	esc_html__( "Enabling this option will display an arrow icon for 1st level menu items which have a dropdown menu", 'hudson' )
);
$panel4->addChild(
	"enable_dropdown_menu_item_icon",
	$enable_dropdown_menu_item_icon
);

$enable_dropdown_top_separator = new HudsonEdgeField(
	"yesno",
	"enable_dropdown_top_separator",
	"no",
	esc_html__( "Enable Dropdown Top Separator", 'hudson' ),
	esc_html__( "Enabling this option will display top separator for second level in dropdown menu", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_disable_dropdown_top_separator_container"
	)
);
$panel4->addChild(
	"enable_dropdown_top_separator",
	$enable_dropdown_top_separator
);

$disable_dropdown_top_separator_container = new HudsonEdgeContainer(
	"disable_dropdown_top_separator_container",
	"enable_dropdown_top_separator",
	"no"
);
$panel4->addChild(
	"disable_dropdown_top_separator_container",
	$disable_dropdown_top_separator_container
);

$dropdown_top_separator_color = new HudsonEdgeField(
	"color",
	"dropdown_top_separator_color",
	"",
	esc_html__( "Dropdown Top Separator Color", 'hudson' ),
	esc_html__( "Choose color for top separator", 'hudson' )
);
$disable_dropdown_top_separator_container->addChild(
	"dropdown_top_separator_color",
	$dropdown_top_separator_color
);

$dropdown_border_around = new HudsonEdgeField(
	"yesno",
	"dropdown_border_around",
	"no",
	esc_html__( "Enable Dropdown Menu Border", 'hudson' ),
	esc_html__( "Enabling this option will display border around dropdown menu", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_dropdown_border_around_container"
	)
);
$panel4->addChild(
	"dropdown_border_around",
	$dropdown_border_around
);

$dropdown_border_around_container = new HudsonEdgeContainer(
	"dropdown_border_around_container",
	"dropdown_border_around",
	"no"
);
$panel4->addChild(
	"dropdown_border_around_container",
	$dropdown_border_around_container
);

$dropdown_border_around_color = new HudsonEdgeField(
	"color",
	"dropdown_border_around_color",
	"",
	esc_html__( "Dropdown Border Color", 'hudson' ),
	esc_html__( "Choose a color for border around dropdown menu", 'hudson' )
);
$dropdown_border_around_container->addChild(
	"dropdown_border_around_color",
	$dropdown_border_around_color
);

$enable_wide_manu_background = new HudsonEdgeField(
	"yesno",
	"enable_wide_manu_background",
	"no",
	esc_html__( "Enable Full Width Background for Wide Dropdown Type", 'hudson' ),
	esc_html__( "Enabling this option will show full width background  for wide dropdown type", 'hudson' ),
	array()
);
$panel4->addChild(
	"enable_wide_manu_background",
	$enable_wide_manu_background
);

$panel3 = new HudsonEdgePanel(
	esc_html__( "Edge Search", 'hudson' ),
	"enable_search_panel",
	"header_type",
	"",
	array( "side", "ribbon" )
);
$headerandfooterPage->addChild(
	"panel3",
	$panel3
);

$enable_search = new HudsonEdgeField(
	"yesno",
	"enable_search",
	"no",
	esc_html__( "Enable Edge Search Bar", 'hudson' ),
	"This option enables Edge Search functionality (search icon will appear next to main navigation)
        ",
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_search_container"
	)
);
$panel3->addChild(
	"enable_search",
	$enable_search
);

$enable_search_container = new HudsonEdgeContainer(
	"enable_search_container",
	"enable_search",
	"no"
);
$panel3->addChild(
	"enable_search_container",
	$enable_search_container
);

$search_type = new HudsonEdgeField(
	"select",
	"search_type",
	"search_slides_from_header_bottom",
	esc_html__( "Edge Search Type", 'hudson' ),
	esc_html__( "Choose a type of Edge search bar (Note: Slide From Header Bottom search type doesn't work with transparent header)", 'hudson' ),
	array(
		"search_slides_from_header_bottom" => esc_html__( "Slide From Header Bottom", 'hudson' ),
		"search_covers_header" => esc_html__( "Search Covers Header", 'hudson' ),
		"fullscreen_search" => esc_html__( "Fullscreen Search", 'hudson' ),
		"search_slides_from_window_top" => esc_html__( "Slide from Window Top", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"search_covers_header"             => "#edgtf_search_height_container,#edgtf_search_animation_container",
			"fullscreen_search"                => "#edgtf_search_height_container,#edgtf_search_cover_header_container",
			"search_slides_from_header_bottom" => "#edgtf_search_animation_container,#edgtf_search_cover_header_container",
			"search_slides_from_window_top"    => "#edgtf_search_animation_container,#edgtf_search_cover_header_container,#edgtf_search_height_container"
		),
		"show"       => array(
			"search_slides_from_header_bottom" => "#edgtf_search_height_container",
			"fullscreen_search"                => "#edgtf_search_animation_container",
			"search_covers_header"             => "#edgtf_search_cover_header_container",
			"search_slides_from_window_top"    => ""
		)
	)
);
$enable_search_container->addChild(
	"search_type",
	$search_type
);

$search_icon_pack = new HudsonEdgeField(
	"select",
	"search_icon_pack",
	"font_awesome",
	esc_html__( "Search Icon Pack", 'hudson' ),
	"Choose
            icon pack for search icon",
	$hudson_edge_icon_collections->getIconCollectionsExclude( 'linea_icons' )
);

$enable_search_container->addChild(
	"search_icon_pack",
	$search_icon_pack
);

$search_height_container = new HudsonEdgeContainer(
	"search_height_container",
	"search_type",
	"",
	array(
		"search_covers_header",
		"fullscreen_search",
		"search_slides_from_window_top"
	)
);
$enable_search_container->addChild(
	"search_height_container",
	$search_height_container
);

$search_height = new HudsonEdgeField(
	"text",
	"search_height",
	"",
	esc_html__( "Search bar height", 'hudson' ),
	esc_html__( "Set search bar height (in pixels)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$search_height_container->addChild(
	"search_height",
	$search_height
);

$search_animation_container = new HudsonEdgeContainer(
	"search_animation_container",
	"search_type",
	"",
	array(
		"search_covers_header",
		"search_slides_from_header_bottom",
		"search_slides_from_window_top"
	)
);
$enable_search_container->addChild(
	"search_animation_container",
	$search_animation_container
);

$search_animation = new HudsonEdgeField(
	"select",
	"search_animation",
	"fade",
	esc_html__( "Fullscreen Search Overlay Animation", 'hudson' ),
	esc_html__( "Choose animation for fullscreen search overlay", 'hudson' ),
	array(
		"fade" => esc_html__( "Fade", 'hudson' ),
		"from_circle" => esc_html__( "Circle appear", 'hudson' )
	)
);
$search_animation_container->addChild(
	"search_animation",
	$search_animation
);

$search_cover_header_container = new HudsonEdgeContainer(
	"search_cover_header_container",
	"search_type",
	"",
	array(
		"fullscreen_search",
		"search_slides_from_header_bottom",
		"search_slides_from_window_top"
	)
);
$enable_search_container->addChild(
	"search_cover_header_container",
	$search_cover_header_container
);

$search_cover_only_bottom_yesno = new HudsonEdgeField(
	"yesno",
	"search_cover_only_bottom_yesno",
	"no",
	esc_html__( "Cover Only Header Bottom", 'hudson' ),
	esc_html__( "Enable this option to make search cover only header bottom", 'hudson' )
);
$search_cover_header_container->addChild(
	"search_cover_only_bottom_yesno",
	$search_cover_only_bottom_yesno
);

$initial_header_icon_title = new HudsonEdgeTitle(
	"initial_header_icon_title",
	esc_html__( "Initial Search Icon in Header", 'hudson' )
);
$enable_search_container->addChild(
	"initial_header_icon_title",
	$initial_header_icon_title
);

$group7 = new HudsonEdgeGroup(
	esc_html__( "Initial Search Icon", 'hudson' ),
	esc_html__( "Define size for Search icon in Header", 'hudson' )
);
$enable_search_container->addChild(
	"group7",
	$group7
);
$row1 = new HudsonEdgeRow();
$group7->addChild(
	"row1",
	$row1
);
$header_search_icon_size = new HudsonEdgeField(
	"textsimple",
	"header_search_icon_size",
	"",
	esc_html__( "Icon Size", 'hudson' ),
	esc_html__( "Set size for icon (ix pixels)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$row1->addChild(
	"header_search_icon_size",
	$header_search_icon_size
);

$group8 = new HudsonEdgeGroup(
	esc_html__( "Icon Background Style", 'hudson' ),
	esc_html__( "Define background style for icon", 'hudson' )
);
$enable_search_container->addChild(
	"group8",
	$group8
);

$row1 = new HudsonEdgeRow();
$group8->addChild(
	"row1",
	$row1
);

$search_icon_background_color = new HudsonEdgeField(
	"colorsimple",
	"search_icon_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Edge search icon", 'hudson' )
);
$row1->addChild(
	"search_icon_background_color",
	$search_icon_background_color
);

$search_icon_background_hover_color = new HudsonEdgeField(
	"colorsimple",
	"search_icon_background_hover_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "Choose a background hover color for Edge search icon", 'hudson' )
);
$row1->addChild(
	"search_icon_background_hover_color",
	$search_icon_background_hover_color
);

$search_icon_background_full_height = new HudsonEdgeField(
	"yesnosimple",
	"search_icon_background_full_height",
	"no",
	esc_html__( "Icon Background Full Height", 'hudson' ),
	esc_html__( "Enabling this option will make seacrh icon background to go full height", 'hudson' )
);
$row1->addChild(
	"search_icon_background_full_height",
	$search_icon_background_full_height
);

$enable_search_icon_text = new HudsonEdgeField(
	"yesno",
	"enable_search_icon_text",
	"no",
	esc_html__( "Enable Search Icon Text", 'hudson' ),
	esc_html__( "Enable this option to show 'Search' text next to search icon in header", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_search_icon_text_container"
	)
);
$enable_search_container->addChild(
	"enable_search_icon_text",
	$enable_search_icon_text
);

$enable_search_icon_text_container = new HudsonEdgeContainer(
	"enable_search_icon_text_container",
	"enable_search_icon_text",
	"no"
);
$enable_search_container->addChild(
	"enable_search_icon_text_container",
	$enable_search_icon_text_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Search Icon Text", 'hudson' ),
	esc_html__( "Define Style for Search Icon Text", 'hudson' )
);
$enable_search_icon_text_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$search_icon_text_color = new HudsonEdgeField(
	"colorsimple",
	"search_icon_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_icon_text_color",
	$search_icon_text_color
);
$search_icon_text_color_hover = new HudsonEdgeField(
	"colorsimple",
	"search_icon_text_color_hover",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_icon_text_color_hover",
	$search_icon_text_color_hover
);
$search_icon_text_fontsize = new HudsonEdgeField(
	"textsimple",
	"search_icon_text_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_icon_text_fontsize",
	$search_icon_text_fontsize
);
$search_icon_text_lineheight = new HudsonEdgeField(
	"textsimple",
	"search_icon_text_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_icon_text_lineheight",
	$search_icon_text_lineheight
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);

$search_icon_text_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"search_icon_text_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"search_icon_text_texttransform",
	$search_icon_text_texttransform
);
$search_icon_text_google_fonts = new HudsonEdgeField(
	esc_html__( "Fontsimple", 'hudson' ),
	"search_icon_text_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"search_icon_text_google_fonts",
	$search_icon_text_google_fonts
);
$search_icon_text_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"search_icon_text_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"search_icon_text_fontstyle",
	$search_icon_text_fontstyle
);
$search_icon_text_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"search_icon_text_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"search_icon_text_fontweight",
	$search_icon_text_fontweight
);

$row3 = new HudsonEdgeRow( true );
$group1->addChild(
	"row3",
	$row3
);

$search_icon_text_letterspacing = new HudsonEdgeField(
	"textsimple",
	"search_icon_text_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"search_icon_text_letterspacing",
	$search_icon_text_letterspacing
);

$group6 = new HudsonEdgeGroup(
	esc_html__( "Icon Spacing", 'hudson' ),
	esc_html__( "Define padding and margins for Search icon", 'hudson' )
);
$enable_search_container->addChild(
	"group6",
	$group6
);

$row1 = new HudsonEdgeRow();
$group6->addChild(
	"row1",
	$row1
);

$search_padding_left = new HudsonEdgeField(
	"textsimple",
	"search_padding_left",
	"",
	esc_html__( "Padding Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_padding_left",
	$search_padding_left
);

$search_padding_right = new HudsonEdgeField(
	"textsimple",
	"search_padding_right",
	"",
	esc_html__( "Padding Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_padding_right",
	$search_padding_right
);

$search_margin_left = new HudsonEdgeField(
	"textsimple",
	"search_margin_left",
	"",
	esc_html__( "Margin Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_margin_left",
	$search_margin_left
);

$search_margin_right = new HudsonEdgeField(
	"textsimple",
	"search_margin_right",
	"",
	esc_html__( "Margin Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_margin_right",
	$search_margin_right
);

$search_form_title = new HudsonEdgeTitle(
	"search_form_title",
	esc_html__( "Edge Search Bar", 'hudson' )
);
$enable_search_container->addChild(
	"search_form_title",
	$search_form_title
);

$search_background_color = new HudsonEdgeField(
	"color",
	"search_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Edge search bar", 'hudson' )
);
$enable_search_container->addChild(
	"search_background_color",
	$search_background_color
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Search Input Text", 'hudson' ),
	esc_html__( "Define Style for Search text", 'hudson' )
);
$enable_search_container->addChild(
	"group1",
	$group1
);
$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);
$search_text_color = new HudsonEdgeField(
	"colorsimple",
	"search_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_text_color",
	$search_text_color
);
$search_text_disabled_color = new HudsonEdgeField(
	"colorsimple",
	"search_text_disabled_color",
	"",
	esc_html__( "Disabled Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_text_disabled_color",
	$search_text_disabled_color
);
$search_text_fontsize = new HudsonEdgeField(
	"textsimple",
	"search_text_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_text_fontsize",
	$search_text_fontsize
);
$search_text_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"search_text_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"search_text_texttransform",
	$search_text_texttransform
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);
$search_text_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"search_text_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"search_text_google_fonts",
	$search_text_google_fonts
);
$search_text_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"search_text_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"search_text_fontstyle",
	$search_text_fontstyle
);
$search_text_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"search_text_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"search_text_fontweight",
	$search_text_fontweight
);
$search_text_letterspacing = new HudsonEdgeField(
	"textsimple",
	"search_text_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"search_text_letterspacing",
	$search_text_letterspacing
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Search Label Text", 'hudson' ),
	esc_html__( "Define Style for Search label text", 'hudson' )
);
$enable_search_container->addChild(
	"group5",
	$group5
);
$row1 = new HudsonEdgeRow();
$group5->addChild(
	"row1",
	$row1
);
$search_label_text_color = new HudsonEdgeField(
	"colorsimple",
	"search_label_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_label_text_color",
	$search_label_text_color
);
$search_label_text_fontsize = new HudsonEdgeField(
	"textsimple",
	"search_label_text_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"search_label_text_fontsize",
	$search_label_text_fontsize
);
$search_label_text_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"search_label_text_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"search_label_text_texttransform",
	$search_label_text_texttransform
);

$row2 = new HudsonEdgeRow( true );
$group5->addChild(
	"row2",
	$row2
);
$search_label_text_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"search_label_text_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"search_label_text_google_fonts",
	$search_label_text_google_fonts
);
$search_label_text_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"search_label_text_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"search_label_text_fontstyle",
	$search_label_text_fontstyle
);
$search_label_text_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"search_label_text_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"search_label_text_fontweight",
	$search_label_text_fontweight
);
$search_label_text_letterspacing = new HudsonEdgeField(
	"textsimple",
	"search_label_text_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"search_label_text_letterspacing",
	$search_label_text_letterspacing
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Search Icon", 'hudson' ),
	esc_html__( "Define Style for Search icon", 'hudson' )
);
$enable_search_container->addChild(
	"group2",
	$group2
);
$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);
$search_icon_color = new HudsonEdgeField(
	"colorsimple",
	"search_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose icon color for Edge search bar", 'hudson' )
);
$row1->addChild(
	"search_icon_color",
	$search_icon_color
);
$search_icon_hover_color = new HudsonEdgeField(
	"colorsimple",
	"search_icon_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose icon hover color for Edge search bar", 'hudson' )
);
$row1->addChild(
	"search_icon_hover_color",
	$search_icon_hover_color
);
$search_icon_disabled_color = new HudsonEdgeField(
	"colorsimple",
	"search_icon_disabled_color",
	"",
	esc_html__( "Icon Disabled Color", 'hudson' ),
	esc_html__( "Choose icon disabled color for Edge search bar", 'hudson' )
);
$row1->addChild(
	"search_icon_disabled_color",
	$search_icon_disabled_color
);
$search_icon_size = new HudsonEdgeField(
	"textsimple",
	"search_icon_size",
	"",
	esc_html__( "Icon Size", 'hudson' ),
	esc_html__( "Set size for icon (ix pixels)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$row1->addChild(
	"search_icon_size",
	$search_icon_size
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Search Close", 'hudson' ),
	esc_html__( "Define style for Search close icon", 'hudson' )
);
$enable_search_container->addChild(
	"group4",
	$group4
);
$row1 = new HudsonEdgeRow();
$group4->addChild(
	"row1",
	$row1
);
$search_close_color = new HudsonEdgeField(
	"colorsimple",
	"search_close_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose color for search close icon", 'hudson' )
);
$row1->addChild(
	"search_close_color",
	$search_close_color
);
$search_close_hover_color = new HudsonEdgeField(
	"colorsimple",
	"search_close_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose hover color for search close icon", 'hudson' )
);
$row1->addChild(
	"search_close_hover_color",
	$search_close_hover_color
);
$search_close_size = new HudsonEdgeField(
	"textsimple",
	"search_close_size",
	"",
	esc_html__( "Icon Size", 'hudson' ),
	esc_html__( "Choose size for search close icon", 'hudson' )
);
$row1->addChild(
	"search_close_size",
	$search_close_size
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Search Bottom Border", 'hudson' ),
	esc_html__( "Define style for Search text input bottom border (for Fullscreen search type)", 'hudson' )
);
$enable_search_container->addChild(
	"group3",
	$group3
);
$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);
$search_border_color = new HudsonEdgeField(
	"colorsimple",
	"search_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border color for search text input", 'hudson' )
);
$row1->addChild(
	"search_border_color",
	$search_border_color
);
$search_border_focus_color = new HudsonEdgeField(
	"colorsimple",
	"search_border_focus_color",
	"",
	esc_html__( "Border Focus Color", 'hudson' ),
	esc_html__( "Choose focus color for search text input", 'hudson' )
);
$row1->addChild(
	"search_border_focus_color",
	$search_border_focus_color
);

$panel11 = new HudsonEdgePanel(
	esc_html__( "Side Area", 'hudson' ),
	"enable_side_area_panel",
	"header_type",
	"",
	array( "side", "ribbon" )
);
$headerandfooterPage->addChild(
	"panel11",
	$panel11
);

$enable_side_area = new HudsonEdgeField(
	"yesno",
	"enable_side_area",
	"yes",
	esc_html__( "Enable Side Area", 'hudson' ),
	esc_html__( "This option enables a side area to be opened from main menu navigation", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_side_area_container"
	)
);
$panel11->addChild(
	"enable_side_area",
	$enable_side_area
);

$enable_side_area_container = new HudsonEdgeContainer(
	"enable_side_area_container",
	"enable_side_area",
	"no"
);
$panel11->addChild(
	"enable_side_area_container",
	$enable_side_area_container
);

$side_area_type = new HudsonEdgeField(
	"select",
	"side_area_type",
	"side_menu_slide_from_right",
	esc_html__( "Side Area Type", 'hudson' ),
	esc_html__( "Choose a type of Side Area", 'hudson' ),
	array(
		"side_menu_slide_from_right" => esc_html__( "Slide from Right Over Content", 'hudson' ),
		"side_menu_slide_with_content" => esc_html__( "Slide from Right With Content", 'hudson' ),
		"side_area_uncovered_from_content" => esc_html__( "Side Area Uncovered from Content", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"side_menu_slide_from_right"       => "#edgtf_side_area_slide_with_content_container",
			"side_menu_slide_with_content"     => "#edgtf_side_area_width_container",
			"side_area_uncovered_from_content" => "#edgtf_side_area_width_container,#edgtf_side_area_slide_with_content_container"
		),
		"show"       => array(
			"side_menu_slide_from_right"       => "#edgtf_side_area_width_container",
			"side_menu_slide_with_content"     => "#edgtf_side_area_slide_with_content_container",
			"side_area_uncovered_from_content" => ""
		)
	)
);

$enable_side_area_container->addChild(
	"side_area_type",
	$side_area_type
);

$side_area_width_container = new HudsonEdgeContainer(
	"side_area_width_container",
	"side_area_type",
	"",
	array(
		"side_menu_slide_with_content",
		"side_area_uncovered_from_content"
	)
);
$enable_side_area_container->addChild(
	"side_area_width_container",
	$side_area_width_container
);

$side_area_width = new HudsonEdgeField(
	"text",
	"side_area_width",
	"",
	esc_html__( "Side Area Width", 'hudson' ),
	esc_html__( "Enter a width for Side Area (in percentages, enter more than 30)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$side_area_width_container->addChild(
	"side_area_width",
	$side_area_width
);

$side_area_content_overlay_color = new HudsonEdgeField(
	"color",
	"side_area_content_overlay_color",
	"",
	esc_html__( "Content Overlay Background Color", 'hudson' ),
	esc_html__( "Choose a background color for a content overlay", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$side_area_width_container->addChild(
	"side_area_content_overlay_color",
	$side_area_content_overlay_color
);

$side_area_content_overlay_opacity = new HudsonEdgeField(
	"text",
	"side_area_content_overlay_opacity",
	"",
	esc_html__( "Content Overlay Background Transparency", 'hudson' ),
	esc_html__( "Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$side_area_width_container->addChild(
	"side_area_content_overlay_opacity",
	$side_area_content_overlay_opacity
);

$side_area_slide_with_content_container = new HudsonEdgeContainer(
	"side_area_slide_with_content_container",
	"side_area_type",
	"",
	array(
		"side_menu_slide_from_right",
		"side_area_uncovered_from_content"
	)
);
$enable_side_area_container->addChild(
	"side_area_slide_with_content_container",
	$side_area_slide_with_content_container
);

$side_area_slide_with_content_width = new HudsonEdgeField(
	"select",
	"side_area_slide_with_content_width",
	"width_470",
	esc_html__( "Side Area Width", 'hudson' ),
	esc_html__( "Choose width for Side Area", 'hudson' ),
	array(
		"width_270" => esc_html__( "270px", 'hudson' ),
		"width_370" => esc_html__( "370px", 'hudson' ),
		"width_470" => esc_html__( "470px", 'hudson' )
	)
);
$side_area_slide_with_content_container->addChild(
	"side_area_slide_with_content_width",
	$side_area_slide_with_content_width
);

$side_area_background_image = new HudsonEdgeField(
	"image",
	"side_area_background_image",
	"",
	esc_html__( "Background Image", 'hudson' ),
	esc_html__( "Choose a background image for Side Area", 'hudson' )
);
$enable_side_area_container->addChild(
	"side_area_background_image",
	$side_area_background_image
);

//init icon pack hide and show array. It will be populated dinamically from collections array
$side_area_icon_pack_hide_array = array();
$side_area_icon_pack_show_array = array();

//do we have some collection added in collections array?
if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//get collections params array. It will contain values of 'param' property for each collection
	$side_area_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	//foreach collection generate hide and show array
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$side_area_icon_pack_hide_array[ $dep_collection_key ] = '';
		
		//we need to include only current collection in show string as it is the only one that needs to show
		$side_area_icon_pack_show_array[ $dep_collection_key ] = '#edgtf_side_area_icon_' . $dep_collection_object->param . '_container';
		
		//for all collections param generate hide string
		foreach ( $side_area_icon_collections_params as $side_area_icon_collections_param ) {
			//we don't need to include current one, because it needs to be shown, not hidden
			if ( $side_area_icon_collections_param !== $dep_collection_object->param ) {
				$side_area_icon_pack_hide_array[ $dep_collection_key ] .= '#edgtf_side_area_icon_' . $side_area_icon_collections_param . '_container,';
			}
		}
		
		//remove remaining ',' character
		$side_area_icon_pack_hide_array[ $dep_collection_key ] = rtrim(
			$side_area_icon_pack_hide_array[ $dep_collection_key ],
			','
		);
	}
	
}

$side_area_button_icon_pack = new HudsonEdgeField(
	"select",
	"side_area_button_icon_pack",
	"font_awesome",
	esc_html__( "Side Area Button Icon Pack", 'hudson' ),
	esc_html__( "Choose icon pack for side area button", 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		"dependence" => true,
		"hide"       => $side_area_icon_pack_hide_array,
		"show"       => $side_area_icon_pack_show_array
	)
);

$enable_side_area_container->addChild(
	"side_area_button_icon_pack",
	$side_area_button_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//foreach icon collection we need to generate separate container that will have dependency set
	//it will have one field inside with icons dropdown
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		//get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		//unset current one, because it doesn't have to be included in dependency that hides icon container
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$side_area_icon_hide_values = $icon_collections_keys;
		$side_area_icon_container   = new HudsonEdgeContainer(
			"side_area_icon_" . $collection_object->param . "_container",
			"side_area_button_icon_pack",
			"",
			$side_area_icon_hide_values
		);
		$side_area_button_icon      = new HudsonEdgeField(
			"select",
			"side_area_icon_" . $collection_object->param,
			"fa-bars",
			esc_html__( "Side Area Icon", 'hudson' ),
			esc_html__( "Choose Side Area Icon", 'hudson' ),
			$icons_array,
			array( "col_width" => 3 )
		);
		$side_area_icon_container->addChild(
			"side_area_icon_" . $collection_object->param,
			$side_area_button_icon
		);
		
		$enable_side_area_container->addChild(
			"side_area_icon_" . $collection_object->param . "_container",
			$side_area_icon_container
		);
	}
	
}

$group6 = new HudsonEdgeGroup(
	esc_html__( "Side Area Icon Spacing", 'hudson' ),
	esc_html__( "Define padding and margin for side area icon", 'hudson' )
);
$enable_side_area_container->addChild(
	"group6",
	$group6
);

$row1 = new HudsonEdgeRow();
$group6->addChild(
	"row1",
	$row1
);

$side_area_icon_padding_left = new HudsonEdgeField(
	"textsimple",
	"side_area_icon_padding_left",
	"",
	esc_html__( "Padding Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_icon_padding_left",
	$side_area_icon_padding_left
);

$side_area_icon_padding_right = new HudsonEdgeField(
	"textsimple",
	"side_area_icon_padding_right",
	"",
	esc_html__( "Padding Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_icon_padding_right",
	$side_area_icon_padding_right
);

$side_area_icon_margin_left = new HudsonEdgeField(
	"textsimple",
	"side_area_icon_margin_left",
	"",
	esc_html__( "Margin Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_icon_margin_left",
	$side_area_icon_margin_left
);

$side_area_icon_margin_right = new HudsonEdgeField(
	"textsimple",
	"side_area_icon_margin_right",
	"",
	esc_html__( "Margin Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_icon_margin_right",
	$side_area_icon_margin_right
);

$side_area_icon_border_yesno = new HudsonEdgeField(
	"yesno",
	"side_area_icon_border_yesno",
	"no",
	esc_html__( "Icon Border", 'hudson' ),
	esc_html__( "Enable border around icon", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_side_area_icon_border_container"
	)
);
$enable_side_area_container->addChild(
	"side_area_icon_border_yesno",
	$side_area_icon_border_yesno
);

$side_area_icon_border_container = new HudsonEdgeContainer(
	"side_area_icon_border_container",
	"side_area_icon_border_yesno",
	"no"
);
$enable_side_area_container->addChild(
	"side_area_icon_border_container",
	$side_area_icon_border_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Border Style", 'hudson' ),
	esc_html__( "Define styling for border around icon", 'hudson' )
);
$side_area_icon_border_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$side_area_icon_border_color = new HudsonEdgeField(
	"colorsimple",
	"side_area_icon_border_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_icon_border_color",
	$side_area_icon_border_color
);

$side_area_icon_border_hover_color = new HudsonEdgeField(
	"colorsimple",
	"side_area_icon_border_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_icon_border_hover_color",
	$side_area_icon_border_hover_color
);

$row2 = new HudsonEdgeRow();
$group1->addChild(
	"row2",
	$row2
);

$side_area_icon_border_width = new HudsonEdgeField(
	"textsimple",
	"side_area_icon_border_width",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"side_area_icon_border_width",
	$side_area_icon_border_width
);

$side_area_icon_border_radius = new HudsonEdgeField(
	"textsimple",
	"side_area_icon_border_radius",
	"",
	esc_html__( "Radius (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"side_area_icon_border_radius",
	$side_area_icon_border_radius
);

$side_area_icon_border_style = new HudsonEdgeField(
	"selectsimple",
	"side_area_icon_border_style",
	"",
	esc_html__( "Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' )
	)
);
$row2->addChild(
	"side_area_icon_border_style",
	$side_area_icon_border_style
);

$side_area_aligment = new HudsonEdgeField(
	"selectblank",
	"side_area_aligment",
	"",
	esc_html__( "Text Aligment", 'hudson' ),
	esc_html__( "Choose text aligment for side area", 'hudson' ),
	array(
		"center" => esc_html__( "Center", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	
	)
);

$enable_side_area_container->addChild(
	"side_area_aligment",
	$side_area_aligment
);

$side_area_title = new HudsonEdgeField(
	"text",
	"side_area_title",
	"",
	esc_html__( "Side Area Title", 'hudson' ),
	esc_html__( "Enter a title to appear in Side Area", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$enable_side_area_container->addChild(
	"side_area_title",
	$side_area_title
);

$side_area_background_color = new HudsonEdgeField(
	"color",
	"side_area_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Side Area", 'hudson' )
);
$enable_side_area_container->addChild(
	"side_area_background_color",
	$side_area_background_color
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Padding", 'hudson' ),
	esc_html__( "Define padding for Side Area", 'hudson' )
);
$enable_side_area_container->addChild(
	"group5",
	$group5
);
$row1 = new HudsonEdgeRow( true );
$group5->addChild(
	"row1",
	$row1
);
$side_area_padding_top = new HudsonEdgeField(
	"textsimple",
	"side_area_padding_top",
	"",
	esc_html__( "Top Padding (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_padding_top",
	$side_area_padding_top
);
$side_area_padding_right = new HudsonEdgeField(
	"textsimple",
	"side_area_padding_right",
	"",
	esc_html__( "Right Padding (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_padding_right",
	$side_area_padding_right
);
$side_area_padding_bottom = new HudsonEdgeField(
	"textsimple",
	"side_area_padding_bottom",
	"",
	esc_html__( "Bottom Padding (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_padding_bottom",
	$side_area_padding_bottom
);
$side_area_padding_left = new HudsonEdgeField(
	"textsimple",
	"side_area_padding_left",
	"",
	esc_html__( "Left Padding (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_padding_left",
	$side_area_padding_left
);

$side_area_close_icon = new HudsonEdgeField(
	"select",
	"side_area_close_icon",
	"light",
	esc_html__( "Close Icon Style", 'hudson' ),
	esc_html__( "Choose a type of close icon", 'hudson' ),
	array(
		"light" => esc_html__( "Light", 'hudson' ),
		"dark" => esc_html__( "Dark", 'hudson' ),
		"custom" => esc_html__( "Custom Color", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"light"  => "#edgtf_side_area_close_icon_custom_container",
			"dark"   => "#edgtf_side_area_close_icon_custom_container",
			"custom" => ""
		),
		"show"       => array(
			"light"  => "",
			"dark"   => "",
			"custom" => "#edgtf_side_area_close_icon_custom_container"
		)
	)
);

$enable_side_area_container->addChild(
	"side_area_close_icon",
	$side_area_close_icon
);

$side_area_close_icon_custom_container = new HudsonEdgeContainer(
	"side_area_close_icon_custom_container",
	"side_area_close_icon",
	"",
	array( "light", "dark" )
);
$enable_side_area_container->addChild(
	"side_area_close_icon_custom_container",
	$side_area_close_icon_custom_container
);

$side_area_close_icon_custom_color = new HudsonEdgeField(
	"color",
	"side_area_close_icon_custom_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color for close icon", 'hudson' )
);
$side_area_close_icon_custom_container->addChild(
	"side_area_close_icon_custom_color",
	$side_area_close_icon_custom_color
);

$side_area_close_icon_size = new HudsonEdgeField(
	"text",
	"side_area_close_icon_size",
	"",
	esc_html__( "Close Icon Size (px)", 'hudson' ),
	esc_html__( "Define close icon size", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$enable_side_area_container->addChild(
	"side_area_close_icon_size",
	$side_area_close_icon_size
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Title", 'hudson' ),
	esc_html__( "Define Style for Side Area title", 'hudson' )
);
$enable_side_area_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);
$side_area_title_color = new HudsonEdgeField(
	"colorsimple",
	"side_area_title_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_title_color",
	$side_area_title_color
);
$side_area_title_fontsize = new HudsonEdgeField(
	"textsimple",
	"side_area_title_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_title_fontsize",
	$side_area_title_fontsize
);
$side_area_title_lineheight = new HudsonEdgeField(
	"textsimple",
	"side_area_title_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_title_lineheight",
	$side_area_title_lineheight
);
$side_area_title_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"side_area_title_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"side_area_title_texttransform",
	$side_area_title_texttransform
);
$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);
$side_area_title_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"side_area_title_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"side_area_title_google_fonts",
	$side_area_title_google_fonts
);
$side_area_title_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"side_area_title_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"side_area_title_fontstyle",
	$side_area_title_fontstyle
);
$side_area_title_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"side_area_title_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"side_area_title_fontweight",
	$side_area_title_fontweight
);
$side_area_title_letterspacing = new HudsonEdgeField(
	"textsimple",
	"side_area_title_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"side_area_title_letterspacing",
	$side_area_title_letterspacing
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Text", 'hudson' ),
	esc_html__( "Define Style for Side Area text", 'hudson' )
);
$enable_side_area_container->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);
$side_area_text_color = new HudsonEdgeField(
	"colorsimple",
	"side_area_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_text_color",
	$side_area_text_color
);
$side_area_text_fontsize = new HudsonEdgeField(
	"textsimple",
	"side_area_text_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_text_fontsize",
	$side_area_text_fontsize
);
$side_area_text_lineheight = new HudsonEdgeField(
	"textsimple",
	"side_area_text_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"side_area_text_lineheight",
	$side_area_text_lineheight
);
$side_area_text_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"side_area_text_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"side_area_text_texttransform",
	$side_area_text_texttransform
);
$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);
$side_area_text_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"side_area_text_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"side_area_text_google_fonts",
	$side_area_text_google_fonts
);
$side_area_text_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"side_area_text_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"side_area_text_fontstyle",
	$side_area_text_fontstyle
);
$side_area_text_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"side_area_text_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"side_area_text_fontweight",
	$side_area_text_fontweight
);
$side_area_text_letterspacing = new HudsonEdgeField(
	"textsimple",
	"side_area_text_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"side_area_text_letterspacing",
	$side_area_text_letterspacing
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Link Style", 'hudson' ),
	esc_html__( "Define styles for side area widget links", 'hudson' )
);
$enable_side_area_container->addChild(
	"group2",
	$group2
);
$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);
$sidearea_link_color = new HudsonEdgeField(
	"colorsimple",
	"sidearea_link_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"sidearea_link_color",
	$sidearea_link_color
);

$sidearea_link_font_size = new HudsonEdgeField(
	"textsimple",
	"sidearea_link_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"sidearea_link_font_size",
	$sidearea_link_font_size
);

$sidearea_link_line_height = new HudsonEdgeField(
	"textsimple",
	"sidearea_link_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"sidearea_link_line_height",
	$sidearea_link_line_height
);

$sidearea_link_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"sidearea_link_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row1->addChild(
	"sidearea_link_text_transform",
	$sidearea_link_text_transform
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);
$sidearea_link_font_family = new HudsonEdgeField(
	"fontsimple",
	"sidearea_link_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"sidearea_link_font_family",
	$sidearea_link_font_family
);

$sidearea_link_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"sidearea_link_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"sidearea_link_font_style",
	$sidearea_link_font_style
);

$sidearea_link_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"sidearea_link_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"sidearea_link_font_weight",
	$sidearea_link_font_weight
);

$sidearea_link_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"sidearea_link_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"sidearea_link_letter_spacing",
	$sidearea_link_letter_spacing
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);
$sidearea_link_hover_color = new HudsonEdgeField(
	"colorsimple",
	"sidearea_link_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"sidearea_link_hover_color",
	$sidearea_link_hover_color
);

$side_area_enable_bottom_border = new HudsonEdgeField(
	"yesno",
	"side_area_enable_bottom_border",
	"no",
	esc_html__( "Border Bottom on Elements", 'hudson' ),
	esc_html__( "Enable border bottom on elements in side area", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_side_area_bottom_border_container"
	)
);
$enable_side_area_container->addChild(
	"side_area_enable_bottom_border",
	$side_area_enable_bottom_border
);

$side_area_bottom_border_container = new HudsonEdgeContainer(
	"side_area_bottom_border_container",
	"side_area_enable_bottom_border",
	"no"
);
$enable_side_area_container->addChild(
	"side_area_bottom_border_container",
	$side_area_bottom_border_container
);

$side_area_bottom_border_color = new HudsonEdgeField(
	"color",
	"side_area_bottom_border_color",
	"",
	esc_html__( "Choose Color for Border Bottom", 'hudson' ),
	esc_html__( "Choose color for border bottom on elements in sidearea", 'hudson' )
);
$side_area_bottom_border_container->addChild(
	"side_area_bottom_border_color",
	$side_area_bottom_border_color
);

// Fullscreen Menu

$panel12 = new HudsonEdgePanel(
	esc_html__( "Fullscreen Menu", 'hudson' ),
	"enable_popup_menu_panel",
	"header_type",
	"",
	array( "side", "ribbon" )
);
$headerandfooterPage->addChild(
	"panel12",
	$panel12
);

$enable_popup_menu = new HudsonEdgeField(
	"yesno",
	"enable_popup_menu",
	"no",
	esc_html__( "Enable Fullscreen Menu", 'hudson' ),
	esc_html__( "This option enables a fullscreen menu to be opened from main menu navigation", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_enable_popup_menu_container"
	)
);
$panel12->addChild(
	"enable_popup_menu",
	$enable_popup_menu
);

$enable_popup_menu_container = new HudsonEdgeContainer(
	"enable_popup_menu_container",
	"enable_popup_menu",
	"no"
);
$panel12->addChild(
	"enable_popup_menu_container",
	$enable_popup_menu_container
);

$popup_menu_animation_style = new HudsonEdgeField(
	"select",
	"popup_menu_animation_style",
	"appear_from_bottom",
	esc_html__( "Fullscreen Menu Overlay Animation", 'hudson' ),
	esc_html__( "Choose animation type for fullscreen menu overlay", 'hudson' ),
	array(
		'fade_push_text_right' => esc_html__( 'Fade Push Text Right', 'hudson' ),
		'fade_push_text_top' => esc_html__( 'Fade Push Text Top', 'hudson' ),
		'fade_text_scaledown' => esc_html__( 'Fade Text Scaledown', 'hudson' )
	)
);
$enable_popup_menu_container->addChild(
	"popup_menu_animation_style",
	$popup_menu_animation_style
);

$logo_image_popup = new HudsonEdgeField(
	"image",
	"logo_image_popup",
	"",
	esc_html__( "Logo in Fullscreen Menu Overlay", 'hudson' ),
	esc_html__( "Place logo in top left corner of fullscreen menu overlay", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"logo_image_popup",
	$logo_image_popup
);

$popup_in_grid = new HudsonEdgeField(
	"yesno",
	"popup_in_grid",
	"no",
	esc_html__( "Fullscreen Menu in Grid", 'hudson' ),
	esc_html__( "Enabling this option will put fullscreen menu content in grid", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"popup_in_grid",
	$popup_in_grid
);

$popup_alignment = new HudsonEdgeField(
	"selectblank",
	"popup_alignment",
	"",
	esc_html__( "Fullscreen Menu Alignment", 'hudson' ),
	esc_html__( "Choose alignment for fullscreen menu content", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$enable_popup_menu_container->addChild(
	"popup_alignment",
	$popup_alignment
);

$group4 = new HudsonEdgeGroup(
	esc_html__( "Background", 'hudson' ),
	esc_html__( "Select a background color and transparency for Fullscreen Menu (0 = fully transparent, 1 = opaque)", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"group4",
	$group4
);

$row1 = new HudsonEdgeRow( true );
$group4->addChild(
	"row1",
	$row1
);

$popup_menu_background_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_background_color",
	$popup_menu_background_color
);
$popup_menu_background_transparency = new HudsonEdgeField(
	"textsimple",
	"popup_menu_background_transparency",
	"",
	esc_html__( "Transparency (values:0-1)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_background_transparency",
	$popup_menu_background_transparency
);

$background_image_popup = new HudsonEdgeField(
	"image",
	"background_image_popup",
	"",
	esc_html__( "Background Image", 'hudson' ),
	esc_html__( "Choose a background image for Fullscreen Menu background", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"background_image_popup",
	$background_image_popup
);

$pattern_image_popup = new HudsonEdgeField(
	"image",
	"pattern_image_popup",
	"",
	esc_html__( "Pattern Background Image", 'hudson' ),
	esc_html__( "Choose a pattern image for Fullscreen Menu background", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"pattern_image_popup",
	$pattern_image_popup
);

$group1 = new HudsonEdgeGroup(
	"1st Level Style",
	esc_html__( "Define styles for 1st level in Fullscreen Menu", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$popup_menu_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_color",
	$popup_menu_color
);
$popup_menu_hover_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_hover_color",
	"",
	esc_html__( "Hover Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_hover_color",
	$popup_menu_hover_color
);
$popup_menu_active_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_active_color",
	"",
	esc_html__( "Active Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_active_color",
	$popup_menu_active_color
);

$row4 = new HudsonEdgeRow();
$group1->addChild(
	"row4",
	$row4
);
$popup_menu_hover_background_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_hover_background_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"popup_menu_hover_background_color",
	$popup_menu_hover_background_color
);
$popup_menu_active_background_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_active_background_color",
	"",
	esc_html__( "Background Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"popup_menu_active_background_color",
	$popup_menu_active_background_color
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);

$popup_menu_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"popup_menu_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_google_fonts",
	$popup_menu_google_fonts
);
$popup_menu_fontsize = new HudsonEdgeField(
	"textsimple",
	"popup_menu_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_fontsize",
	$popup_menu_fontsize
);
$popup_menu_lineheight = new HudsonEdgeField(
	"textsimple",
	"popup_menu_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_lineheight",
	$popup_menu_lineheight
);

$row3 = new HudsonEdgeRow( true );
$group1->addChild(
	"row3",
	$row3
);

$popup_menu_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"popup_menu_fontstyle",
	$popup_menu_fontstyle
);
$popup_menu_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"popup_menu_fontweight",
	$popup_menu_fontweight
);
$popup_menu_letterspacing = new HudsonEdgeField(
	"textsimple",
	"popup_menu_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"popup_menu_letterspacing",
	$popup_menu_letterspacing
);
$popup_menu_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"popup_menu_texttransform",
	$popup_menu_texttransform
);

$group2 = new HudsonEdgeGroup(
	"2nd Level Style",
	esc_html__( "Define styles for 2nd level in Fullscreen Menu", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$popup_menu_color_2nd = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_color_2nd",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_color_2nd",
	$popup_menu_color_2nd
);
$popup_menu_hover_color_2nd = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_hover_color_2nd",
	"",
	esc_html__( "Hover Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_hover_color_2nd",
	$popup_menu_hover_color_2nd
);
$popup_menu_hover_background_color_2nd = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_hover_background_color_2nd",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_hover_background_color_2nd",
	$popup_menu_hover_background_color_2nd
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);

$popup_menu_google_fonts_2nd = new HudsonEdgeField(
	"fontsimple",
	"popup_menu_google_fonts_2nd",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_google_fonts_2nd",
	$popup_menu_google_fonts_2nd
);
$popup_menu_fontsize_2nd = new HudsonEdgeField(
	"textsimple",
	"popup_menu_fontsize_2nd",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_fontsize_2nd",
	$popup_menu_fontsize_2nd
);
$popup_menu_lineheight_2nd = new HudsonEdgeField(
	"textsimple",
	"popup_menu_lineheight_2nd",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_lineheight_2nd",
	$popup_menu_lineheight_2nd
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);

$popup_menu_fontstyle_2nd = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_fontstyle_2nd",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"popup_menu_fontstyle_2nd",
	$popup_menu_fontstyle_2nd
);
$popup_menu_fontweight_2nd = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_fontweight_2nd",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"popup_menu_fontweight_2nd",
	$popup_menu_fontweight_2nd
);
$popup_menu_letterspacing_2nd = new HudsonEdgeField(
	"textsimple",
	"popup_menu_letterspacing_2nd",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"popup_menu_letterspacing_2nd",
	$popup_menu_letterspacing_2nd
);
$popup_menu_texttransform_2nd = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_texttransform_2nd",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"popup_menu_texttransform_2nd",
	$popup_menu_texttransform_2nd
);

$group3 = new HudsonEdgeGroup(
	"3rd Level Style",
	esc_html__( "Define styles for 3rd level in Fullscreen Menu", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$popup_menu_3rd_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_3rd_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_3rd_color",
	$popup_menu_3rd_color
);
$popup_menu_3rd_hover_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_3rd_hover_color",
	"",
	esc_html__( "Hover Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_3rd_hover_color",
	$popup_menu_3rd_hover_color
);
$popup_menu_3rd_hover_background_color = new HudsonEdgeField(
	"colorsimple",
	"popup_menu_3rd_hover_background_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_3rd_hover_background_color",
	$popup_menu_3rd_hover_background_color
);

$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);

$popup_menu_3rd_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"popup_menu_3rd_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_3rd_google_fonts",
	$popup_menu_3rd_google_fonts
);
$popup_menu_3rd_fontsize = new HudsonEdgeField(
	"textsimple",
	"popup_menu_3rd_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_3rd_fontsize",
	$popup_menu_3rd_fontsize
);
$popup_menu_3rd_lineheight = new HudsonEdgeField(
	"textsimple",
	"popup_menu_3rd_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$popup_menu_3rd_lineheight = new HudsonEdgeField(
	"textsimple",
	"popup_menu_3rd_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"popup_menu_3rd_lineheight",
	$popup_menu_3rd_lineheight
);

$row3 = new HudsonEdgeRow( true );
$group3->addChild(
	"row3",
	$row3
);

$popup_menu_3rd_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_3rd_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"popup_menu_3rd_fontstyle",
	$popup_menu_3rd_fontstyle
);
$popup_menu_3rd_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_3rd_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"popup_menu_3rd_fontweight",
	$popup_menu_3rd_fontweight
);
$popup_menu_3rd_letterspacing = new HudsonEdgeField(
	"textsimple",
	"popup_menu_3rd_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"popup_menu_3rd_letterspacing",
	$popup_menu_3rd_letterspacing
);
$popup_menu_3rd_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"popup_menu_3rd_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"popup_menu_3rd_texttransform",
	$popup_menu_3rd_texttransform
);

$group5 = new HudsonEdgeGroup(
	esc_html__( "Full Screen Menu Icon Spacing", 'hudson' ),
	esc_html__( "Define padding and margin for full screen menu icon", 'hudson' )
);
$enable_popup_menu_container->addChild(
	"group5",
	$group5
);

$row1 = new HudsonEdgeRow();
$group5->addChild(
	"row1",
	$row1
);

$popup_menu_icon_padding_left = new HudsonEdgeField(
	"textsimple",
	"popup_menu_icon_padding_left",
	"",
	esc_html__( "Padding Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_icon_padding_left",
	$popup_menu_icon_padding_left
);

$popup_menu_icon_padding_right = new HudsonEdgeField(
	"textsimple",
	"popup_menu_icon_padding_right",
	"",
	esc_html__( "Padding Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_icon_padding_right",
	$popup_menu_icon_padding_right
);

$popup_menu_icon_margin_left = new HudsonEdgeField(
	"textsimple",
	"popup_menu_icon_margin_left",
	"",
	esc_html__( "Margin Left (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_icon_margin_left",
	$popup_menu_icon_margin_left
);

$popup_menu_icon_margin_right = new HudsonEdgeField(
	"textsimple",
	"popup_menu_icon_margin_right",
	"",
	esc_html__( "Margin Right (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"popup_menu_icon_margin_right",
	$popup_menu_icon_margin_right
);

$panel2 = new HudsonEdgePanel(
	esc_html__( "Header Top", 'hudson' ),
	"header_top_panel",
	"header_type",
	"",
	array( "side", "ribbon" )
);
$headerandfooterPage->addChild(
	"panel2",
	$panel2
);

$header_top_area = new HudsonEdgeField(
	"yesno",
	"header_top_area",
	"no",
	esc_html__( "Show Header Top Area", 'hudson' ),
	"Enabling this option will show Header Top area (this setting applies to Header Left and Header Right widgets)
    ",
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_header_top_area_container"
	)
);
$panel2->addChild(
	"header_top_area",
	$header_top_area
);

$header_top_area_container = new HudsonEdgeContainer(
	"header_top_area_container",
	"header_top_area",
	"no"
);
$panel2->addChild(
	"header_top_area_container",
	$header_top_area_container
);

$header_top_area_scroll_container = new HudsonEdgeContainer(
	"header_top_area_scroll_container",
	"header_bottom_appearance",
	"",
	array( "fixed_top_header" )
);
$header_top_area_container->addChild(
	"header_top_area_scroll_container",
	$header_top_area_scroll_container
);

$header_top_area_scroll = new HudsonEdgeField(
	"yesno",
	"header_top_area_scroll",
	"no",
	esc_html__( "Hide on Scroll", 'hudson' ),
	esc_html__( "Enabling this option will hide Header Top on scroll (if fixed header types are chosen)", 'hudson' )
);
$header_top_area_scroll_container->addChild(
	"header_top_area_scroll",
	$header_top_area_scroll
);

$header_top_height = new HudsonEdgeField(
	"text",
	"header_top_height",
	"",
	esc_html__( "Header Top Height", 'hudson' ),
	esc_html__( "Enter height for header top", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_top_area_container->addChild(
	"header_top_height",
	$header_top_height
);

$header_top_has_background_pattern = new HudsonEdgeField(
	"yesno",
	"header_top_has_background_pattern",
	"no",
	esc_html__( "Background Pattern Image", 'hudson' ),
	"Enabling this option will display background pattern image in header top area.
		",
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_header_top_background_pattern_image_container"
	)
);
$header_top_area_container->addChild(
	"header_top_has_background_pattern",
	$header_top_has_background_pattern
);

$header_top_background_pattern_image_container = new HudsonEdgeContainer(
	"header_top_background_pattern_image_container",
	"header_top_has_background_pattern",
	"no"
);
$header_top_area_container->addChild(
	"header_top_background_pattern_image_container",
	$header_top_background_pattern_image_container
);

$group10 = new HudsonEdgeGroup(
	esc_html__( "Image", 'hudson' ),
	esc_html__( "Choose pattern image for header top background", 'hudson' )
);
$header_top_background_pattern_image_container->addChild(
	"group10",
	$group10
);
$row1 = new HudsonEdgeRow();
$group10->addChild(
	"row1",
	$row1
);

$header_top_background_pattern_image = new HudsonEdgeField(
	"imagesimple",
	"header_top_background_pattern_image",
	"",
	esc_html__( "Pattern Image", 'hudson' ),
	""
);
$row1->addChild(
	"header_top_background_pattern_image",
	$header_top_background_pattern_image
);

$header_top_background_color = new HudsonEdgeField(
	"color",
	"header_top_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Header Top area", 'hudson' )
);
$header_top_area_container->addChild(
	"header_top_background_color",
	$header_top_background_color
);

$header_top_transparency = new HudsonEdgeField(
	"text",
	"header_top_transparency",
	"",
	esc_html__( "Header Top Transparency", 'hudson' ),
	esc_html__( "Choose a transparency for the Header Top background color (0 = fully transparent, 1 = opaque)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_top_area_container->addChild(
	"header_top_transparency",
	$header_top_transparency
);

$top_header_border_color = new HudsonEdgeField(
	"color",
	"top_header_border_color",
	"",
	esc_html__( "Border Bottom Color", 'hudson' ),
	esc_html__( "Set a color for the bottom border of the Header Top Area.", 'hudson' )
);
$header_top_area_container->addChild(
	"top_header_border_color",
	$top_header_border_color
);

$top_header_border_weight = new HudsonEdgeField(
	"text",
	"top_header_border_weight",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "Set a border width for the bottom border of the Header Top Area.", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$header_top_area_container->addChild(
	"top_header_border_weight",
	$top_header_border_weight
);

$group_header_top_menu = new HudsonEdgeGroup(
	esc_html__( "Menu Item Text Decoration", 'hudson' ),
	""
);
$header_top_area_container->addChild(
	"group_header_top_menu",
	$group_header_top_menu
);

$row1 = new HudsonEdgeRow();
$group_header_top_menu->addChild(
	"row1",
	$row1
);

$header_top_menu_item_text_decoration_style = new HudsonEdgeField(
	"selectsimple",
	"header_top_menu_item_text_decoration_style",
	"none",
	esc_html__( "Hover Item Text Decoration", 'hudson' ),
	esc_html__( "Choose text decoration type for hover menu items", 'hudson' ),
	array(
		"none" => esc_html__( "None", 'hudson' ),
		"underline" => esc_html__( "Underline", 'hudson' ),
		"line-through" => esc_html__( "Line-through", 'hudson' ),
		"overline" => esc_html__( "Overline", 'hudson' )
	)
);
$row1->addChild(
	"header_top_menu_item_text_decoration_style",
	$header_top_menu_item_text_decoration_style
);

$header_top_menu_active_text_decoration_style = new HudsonEdgeField(
	"selectsimple",
	"header_top_menu_active_text_decoration_style",
	"none",
	esc_html__( "Active Item Text Decoration", 'hudson' ),
	esc_html__( "Choose text decoration type for active menu items", 'hudson' ),
	array(
		"none" => esc_html__( "None", 'hudson' ),
		"underline" => esc_html__( "Underline", 'hudson' ),
		"line-through" => esc_html__( "Line-through", 'hudson' ),
		"overline" => esc_html__( "Overline", 'hudson' )
	)
);
$row1->addChild(
	"header_top_menu_active_text_decoration_style",
	$header_top_menu_active_text_decoration_style
);

$widget_elements_header_top = new HudsonEdgeTitle(
	"widget_elements_header_top",
	esc_html__( "Widget Elements", 'hudson' )
);
$header_top_area_container->addChild(
	"widget_elements_header_top",
	$widget_elements_header_top
);

$group9 = new HudsonEdgeGroup(
	esc_html__( "Search", 'hudson' ),
	esc_html__( "Define styles for search in widget", 'hudson' )
);
$header_top_area_container->addChild(
	"group9",
	$group9
);

$row1 = new HudsonEdgeRow();
$group9->addChild(
	"row1",
	$row1
);

$header_top_search_height = new HudsonEdgeField(
	"textsimple",
	"header_top_search_height",
	"",
	esc_html__( "Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"header_top_search_height",
	$header_top_search_height
);

$header_top_search_border_color = new HudsonEdgeField(
	"colorsimple",
	"header_top_search_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"header_top_search_border_color",
	$header_top_search_border_color
);

$header_top_search_loupe_color = new HudsonEdgeField(
	"colorsimple",
	"header_top_search_loupe_color",
	"",
	esc_html__( "Magnifier Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"header_top_search_loupe_color",
	$header_top_search_loupe_color
);

$header_top_search_loupe_background_color = new HudsonEdgeField(
	"colorsimple",
	"header_top_search_loupe_background_color",
	"",
	esc_html__( "Magnifier Area Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"header_top_search_loupe_background_color",
	$header_top_search_loupe_background_color
);

$row2 = new HudsonEdgeRow();
$group9->addChild(
	"row2",
	$row2
);

$header_top_search_text_color = new HudsonEdgeField(
	"colorsimple",
	"header_top_search_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"header_top_search_text_color",
	$header_top_search_text_color
);

$header_top_search_focus_text_color = new HudsonEdgeField(
	"colorsimple",
	"header_top_search_focus_text_color",
	"",
	esc_html__( "Focus Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"header_top_search_focus_text_color",
	$header_top_search_focus_text_color
);

$header_top_search_text_font_size = new HudsonEdgeField(
	"textsimple",
	"header_top_search_text_font_size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"header_top_search_text_font_size",
	$header_top_search_text_font_size
);

$header_top_search_text_line_height = new HudsonEdgeField(
	"textsimple",
	"header_top_search_text_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"header_top_search_text_line_height",
	$header_top_search_text_line_height
);

$row3 = new HudsonEdgeRow( true );
$group9->addChild(
	"row3",
	$row3
);

$header_top_search_text_text_transform = new HudsonEdgeField(
	"selectblanksimple",
	"header_top_search_text_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"header_top_search_text_text_transform",
	$header_top_search_text_text_transform
);

$header_top_search_text_font_family = new HudsonEdgeField(
	"fontsimple",
	"header_top_search_text_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"header_top_search_text_font_family",
	$header_top_search_text_font_family
);

$header_top_search_text_font_style = new HudsonEdgeField(
	"selectblanksimple",
	"header_top_search_text_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"header_top_search_text_font_style",
	$header_top_search_text_font_style
);

$header_top_search_text_font_weight = new HudsonEdgeField(
	"selectblanksimple",
	"header_top_search_text_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"header_top_search_text_font_weight",
	$header_top_search_text_font_weight
);

$row4 = new HudsonEdgeRow( true );
$group9->addChild(
	"row4",
	$row4
);

$header_top_search_text_letter_spacing = new HudsonEdgeField(
	"textsimple",
	"header_top_search_text_letter_spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"header_top_search_text_letter_spacing",
	$header_top_search_text_letter_spacing
);

$header_top_search_border_around = new HudsonEdgeField(
	"selectsimple",
	"header_top_search_border_around",
	"",
	esc_html__( "Border Around", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"around_everything" => esc_html__( "Around Everything", 'hudson' ),
		"around_search_text" => esc_html__( "Around Search Text", 'hudson' )
	)
);
$row4->addChild(
	"header_top_search_border_around",
	$header_top_search_border_around
);

$row5 = new HudsonEdgeRow( true );
$group9->addChild(
	"row5",
	$row5
);

$header_top_search_width = new HudsonEdgeField(
	"textsimple",
	"header_top_search_width",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row5->addChild(
	"header_top_search_text_font_size",
	$header_top_search_width
);

$header_top_search_margin_left = new HudsonEdgeField(
	"textsimple",
	"header_top_search_margin_left",
	"",
	esc_html__( "Left Margin (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row5->addChild(
	"header_top_search_margin_left",
	$header_top_search_margin_left
);

$header_top_search_margin_right = new HudsonEdgeField(
	"textsimple",
	"header_top_search_margin_right",
	"",
	esc_html__( "Right Margin (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row5->addChild(
	"header_top_search_margin_right",
	$header_top_search_margin_right
);

$panel72 = new HudsonEdgePanel(
	esc_html__( "Ribbon Menu", 'hudson' ),
	"ribbon_menu_panel",
	"header_type",
	"",
	array( "top", "side" )
);
$headerandfooterPage->addChild(
	"panel72",
	$panel72
);

$ribbon_bckg_color = new HudsonEdgeField(
	"color",
	"ribbon_bckg_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a color for Ribbon background", 'hudson' )
);
$panel72->addChild(
	"ribbon_bckg_color",
	$ribbon_bckg_color
);

$ribbon_text_alignment = new HudsonEdgeField(
	"selectblank",
	"ribbon_text_alignment",
	"",
	esc_html__( "Ribbon Menu Text Alignment", 'hudson' ),
	esc_html__( "Specify alignment for menu", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$panel72->addChild(
	"ribbon_text_alignment",
	$ribbon_text_alignment
);

$ribbon_open_close_arrow_color = new HudsonEdgeField(
	"color",
	"ribbon_open_close_arrow_color",
	"",
	esc_html__( "Open/Close Arrow Color", 'hudson' ),
	esc_html__( "Choose a color for the open/close arrow", 'hudson' )
);
$panel72->addChild(
	"ribbon_open_close_arrow_color",
	$ribbon_open_close_arrow_color
);

$ribbon_border_arround_menu = new HudsonEdgeField(
	"yesno",
	"ribbon_border_arround_menu",
	"yes",
	esc_html__( "Border Around Ribbon", 'hudson' ),
	esc_html__( "Choose if you would like to enable a border around the ribbon and dropdown menu", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_ribbon_border_arround_menu_container"
	)
);
$panel72->addChild(
	"ribbon_border_arround_menu",
	$ribbon_border_arround_menu
);

$ribbon_border_arround_menu_container = new HudsonEdgeContainer(
	"ribbon_border_arround_menu_container",
	"ribbon_border_arround_menu",
	"no"
);
$panel72->addChild(
	"ribbon_border_arround_menu_container",
	$ribbon_border_arround_menu_container
);

$ribbon_border_arround_menu_color = new HudsonEdgeField(
	"color",
	"ribbon_border_arround_menu_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose border color", 'hudson' )
);
$ribbon_border_arround_menu_container->addChild(
	"ribbon_border_arround_menu_color",
	$ribbon_border_arround_menu_color
);

$ribbon_menu_items_top_bottom_padding = new HudsonEdgeField(
	"text",
	"ribbon_menu_items_top_bottom_padding",
	"",
	esc_html__( "Menu Items Top/Bottom Padding", 'hudson' ),
	esc_html__( "Enter padding for top and bottom of menu items (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel72->addChild(
	"ribbon_menu_items_top_bottom_padding",
	$ribbon_menu_items_top_bottom_padding
);

$ribbon_menu_items_left_right_padding = new HudsonEdgeField(
	"text",
	"ribbon_menu_items_left_right_padding",
	"",
	esc_html__( "Menu Items Left/Right Padding", 'hudson' ),
	esc_html__( "Enter padding for left and right of menu items (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel72->addChild(
	"ribbon_menu_items_left_right_padding",
	$ribbon_menu_items_left_right_padding
);

$ribbon_dropdown_menu_label = new HudsonEdgeTitle(
	"ribbon_dropdown_menu_label",
	esc_html__( "Dropdown Menu", 'hudson' )
);
$panel72->addChild(
	"ribbon_dropdown_menu_label",
	$ribbon_dropdown_menu_label
);

$ribbon_dropdown_menu_bckg_color = new HudsonEdgeField(
	"color",
	"ribbon_dropdown_menu_bckg_color",
	"",
	esc_html__( "Dropdown Background Color", 'hudson' ),
	esc_html__( "Choose a color for dropdown background", 'hudson' )
);
$panel72->addChild(
	"ribbon_dropdown_menu_bckg_color",
	$ribbon_dropdown_menu_bckg_color
);

$ribbon_dropdown_top_padding = new HudsonEdgeField(
	"text",
	"ribbon_dropdown_top_padding",
	"",
	esc_html__( "Dropdown Top Padding", 'hudson' ),
	esc_html__( "Enter top padding for dropdown (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel72->addChild(
	"ribbon_dropdown_top_padding",
	$ribbon_dropdown_top_padding
);

$ribbon_dropdown_bottom_padding = new HudsonEdgeField(
	"text",
	"ribbon_dropdown_bottom_padding",
	"",
	esc_html__( "Dropdown Bottom Padding", 'hudson' ),
	esc_html__( "Enter bottom padding for dropdown (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel72->addChild(
	"ribbon_dropdown_bottom_padding",
	$ribbon_dropdown_bottom_padding
);

$ribbon_menu_text_icons = new HudsonEdgeTitle(
	"ribbon_menu_text_icons",
	esc_html__( "Menu Text and Icons", 'hudson' )
);
$panel72->addChild(
	"ribbon_menu_text_icons",
	$ribbon_menu_text_icons
);

$group1 = new HudsonEdgeGroup(
	"1st Level Menu Style",
	esc_html__( "Define styles for 1st level in Ribbon Menu", 'hudson' )
);
$panel72->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$ribbon_menu_color = new HudsonEdgeField(
	"colorsimple",
	"ribbon_menu_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"ribbon_menu_color",
	$ribbon_menu_color
);
$ribbon_menu_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"ribbon_menu_hovercolor",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"ribbon_menu_hovercolor",
	$ribbon_menu_hovercolor
);
$ribbon_menu_activecolor = new HudsonEdgeField(
	"colorsimple",
	"ribbon_menu_activecolor",
	"",
	esc_html__( "Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"ribbon_menu_activecolor",
	$ribbon_menu_activecolor
);

$row4 = new HudsonEdgeRow();
$group1->addChild(
	"row4",
	$row4
);

$ribbon_menu_icon_color = new HudsonEdgeField(
	"colorsimple",
	"ribbon_menu_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"ribbon_menu_icon_color",
	$ribbon_menu_icon_color
);
$ribbon_menu_icon_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"ribbon_menu_icon_hovercolor",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"ribbon_menu_icon_hovercolor",
	$ribbon_menu_icon_hovercolor
);
$ribbon_menu_icon_activecolor = new HudsonEdgeField(
	"colorsimple",
	"ribbon_menu_icon_activecolor",
	"",
	esc_html__( "Icon Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"ribbon_menu_icon_activecolor",
	$ribbon_menu_icon_activecolor
);
$ribbon_menu_icon_margin = new HudsonEdgeField(
	"textsimple",
	"ribbon_menu_icon_margin",
	"",
	esc_html__( "Space between text and icon (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"ribbon_menu_icon_margin",
	$ribbon_menu_icon_margin
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);

$ribbon_menu_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"ribbon_menu_google_fonts",
	"-1",
	esc_html__( "Font family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_menu_google_fonts",
	$ribbon_menu_google_fonts
);
$ribbon_menu_fontsize = new HudsonEdgeField(
	"textsimple",
	"ribbon_menu_fontsize",
	"",
	esc_html__( "Font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_menu_fontsize",
	$ribbon_menu_fontsize
);
$ribbon_menu_icon_fontsize = new HudsonEdgeField(
	"textsimple",
	"ribbon_menu_icon_fontsize",
	"",
	esc_html__( "Icon font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_menu_icon_fontsize",
	$ribbon_menu_icon_fontsize
);
$ribbon_menu_lineheight = new HudsonEdgeField(
	"textsimple",
	"ribbon_menu_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_menu_lineheight",
	$ribbon_menu_lineheight
);

$row3 = new HudsonEdgeRow( true );
$group1->addChild(
	"row3",
	$row3
);

$ribbon_menu_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_menu_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"ribbon_menu_fontstyle",
	$ribbon_menu_fontstyle
);
$ribbon_menu_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_menu_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"ribbon_menu_fontweight",
	$ribbon_menu_fontweight
);
$ribbon_menu_letterspacing = new HudsonEdgeField(
	"textsimple",
	"ribbon_menu_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"ribbon_menu_letterspacing",
	$ribbon_menu_letterspacing
);
$ribbon_menu_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_menu_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"ribbon_menu_texttransform",
	$ribbon_menu_texttransform
);

$group2 = new HudsonEdgeGroup(
	"2nd Level Menu Style",
	esc_html__( "Define styles for 2nd level in Ribbon Menu", 'hudson' )
);
$panel72->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$ribbon_dropdown_color = new HudsonEdgeField(
	"colorsimple",
	"ribbon_dropdown_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"ribbon_dropdown_color",
	$ribbon_dropdown_color
);
$ribbon_dropdown_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"ribbon_dropdown_hovercolor",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"ribbon_dropdown_hovercolor",
	$ribbon_dropdown_hovercolor
);

$row4 = new HudsonEdgeRow();
$group2->addChild(
	"row4",
	$row4
);
$ribbon_dropdown_icon_color = new HudsonEdgeField(
	"colorsimple",
	"ribbon_dropdown_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"ribbon_dropdown_icon_color",
	$ribbon_dropdown_icon_color
);
$ribbon_dropdown_icon_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"ribbon_dropdown_icon_hovercolor",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"ribbon_dropdown_icon_hovercolor",
	$ribbon_dropdown_icon_hovercolor
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);

$ribbon_dropdown_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"ribbon_dropdown_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_dropdown_google_fonts",
	$ribbon_dropdown_google_fonts
);
$ribbon_dropdown_fontsize = new HudsonEdgeField(
	"textsimple",
	"ribbon_dropdown_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_dropdown_fontsize",
	$ribbon_dropdown_fontsize
);
$ribbon_dropdown_icon_fontsize = new HudsonEdgeField(
	"textsimple",
	"ribbon_dropdown_icon_fontsize",
	"",
	esc_html__( "Icon font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_dropdown_icon_fontsize",
	$ribbon_dropdown_icon_fontsize
);
$ribbon_dropdown_lineheight = new HudsonEdgeField(
	"textsimple",
	"ribbon_dropdown_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_dropdown_lineheight",
	$ribbon_dropdown_lineheight
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);

$ribbon_dropdown_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_dropdown_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"ribbon_dropdown_fontstyle",
	$ribbon_dropdown_fontstyle
);
$ribbon_dropdown_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_dropdown_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"ribbon_dropdown_fontweight",
	$ribbon_dropdown_fontweight
);
$ribbon_dropdown_letterspacing = new HudsonEdgeField(
	"textsimple",
	"ribbon_dropdown_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"ribbon_dropdown_letterspacing",
	$ribbon_dropdown_letterspacing
);
$ribbon_dropdown_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_dropdown_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"ribbon_dropdown_texttransform",
	$ribbon_dropdown_texttransform
);

$group3 = new HudsonEdgeGroup(
	"3rd Level Menu Style",
	esc_html__( "Define styles for 3rd level in Ribbon Menu", 'hudson' )
);
$panel72->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$ribbon_dropdown_color_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"ribbon_dropdown_color_thirdlvl",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"ribbon_dropdown_color_thirdlvl",
	$ribbon_dropdown_color_thirdlvl
);
$ribbon_dropdown_hovercolor_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"ribbon_dropdown_hovercolor_thirdlvl",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"ribbon_dropdown_hovercolor_thirdlvl",
	$ribbon_dropdown_hovercolor_thirdlvl
);

$row4 = new HudsonEdgeRow();
$group3->addChild(
	"row4",
	$row4
);
$ribbon_dropdown_icon_color_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"ribbon_dropdown_icon_color_thirdlvl",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"ribbon_dropdown_icon_color_thirdlvl",
	$ribbon_dropdown_icon_color_thirdlvl
);
$ribbon_dropdown_icon_hovercolor_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"ribbon_dropdown_icon_hovercolor_thirdlvl",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"ribbon_dropdown_icon_hovercolor_thirdlvl",
	$ribbon_dropdown_icon_hovercolor_thirdlvl
);

$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);

$ribbon_dropdown_google_fonts_thirdlvl = new HudsonEdgeField(
	"fontsimple",
	"ribbon_dropdown_google_fonts_thirdlvl",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_dropdown_google_fonts_thirdlvl",
	$ribbon_dropdown_google_fonts_thirdlvl
);
$ribbon_dropdown_fontsize_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"ribbon_dropdown_fontsize_thirdlvl",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_dropdown_fontsize_thirdlvl",
	$ribbon_dropdown_fontsize_thirdlvl
);
$ribbon_dropdown_icon_fontsize_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"ribbon_dropdown_icon_fontsize_thirdlvl",
	"",
	esc_html__( "Icon font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_dropdown_icon_fontsize_thirdlvl",
	$ribbon_dropdown_icon_fontsize_thirdlvl
);
$ribbon_dropdown_lineheight_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"ribbon_dropdown_lineheight_thirdlvl",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"ribbon_dropdown_lineheight_thirdlvl",
	$ribbon_dropdown_lineheight_thirdlvl
);

$row3 = new HudsonEdgeRow( true );
$group3->addChild(
	"row3",
	$row3
);

$ribbon_dropdown_fontstyle_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_dropdown_fontstyle_thirdlvl",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"ribbon_dropdown_fontstyle_thirdlvl",
	$ribbon_dropdown_fontstyle_thirdlvl
);
$ribbon_dropdown_fontweight_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_dropdown_fontweight_thirdlvl",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"ribbon_dropdown_fontweight_thirdlvl",
	$ribbon_dropdown_fontweight_thirdlvl
);
$ribbon_dropdown_letterspacing_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"ribbon_dropdown_letterspacing_thirdlvl",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"ribbon_dropdown_letterspacing_thirdlvl",
	$ribbon_dropdown_letterspacing_thirdlvl
);
$ribbon_dropdown_texttransform_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"ribbon_dropdown_texttransform_thirdlvl",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"ribbon_dropdown_texttransform_thirdlvl",
	$ribbon_dropdown_texttransform_thirdlvl
);

$panel7 = new HudsonEdgePanel(
	esc_html__( "Side Menu Area", 'hudson' ),
	"vertical_areas_panel",
	"header_type",
	"",
	array( "top", "ribbon" )
);
$headerandfooterPage->addChild(
	"panel7",
	$panel7
);

$vertical_area_type = new HudsonEdgeField(
	"select",
	"vertical_area_type",
	"left",
	esc_html__( "Side Menu Area Type", 'hudson' ),
	esc_html__( "Specify menu type", 'hudson' ),
	array(
		"" => esc_html__( "Always Opened (Default)", 'hudson' ),
		"hidden" => esc_html__( "Initially Hidden", 'hudson' ),
		"hidden_with_icons" => esc_html__( "Initially Hidden With Visible Icons", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			""                  => "#edgtf_vertical_area_hidden_button_color_container",
			"hidden"            => "",
			"hidden_with_icons" => "#edgtf_enable_vertical_menu_item_left_border_container"
		),
		"show"       => array(
			""                  => "#edgtf_enable_vertical_menu_item_left_border_container",
			"hidden"            => "#edgtf_vertical_area_hidden_button_color_container, #edgtf_enable_vertical_menu_item_left_border_container",
			"hidden_with_icons" => "#edgtf_vertical_area_hidden_button_color_container"
		)
	)
);
$panel7->addChild(
	"vertical_area_type",
	$vertical_area_type
);

$vertical_area_hidden_button_color_container = new HudsonEdgeContainer(
	"vertical_area_hidden_button_color_container",
	"vertical_area_type",
	""
);
$panel7->addChild(
	"vertical_area_hidden_button_color_container",
	$vertical_area_hidden_button_color_container
);

$vertical_area_hidden_button_color = new HudsonEdgeField(
	"color",
	"vertical_area_hidden_button_color",
	"",
	esc_html__( "Button Color", 'hudson' ),
	esc_html__( "Choose a color for button that opens/closes Hidden Side Menu Area", 'hudson' )
);
$vertical_area_hidden_button_color_container->addChild(
	"vertical_area_hidden_button_color",
	$vertical_area_hidden_button_color
);

$vertical_area_width = new HudsonEdgeField(
	"select",
	"vertical_area_width",
	"width_290",
	esc_html__( "Side Menu Area Width", 'hudson' ),
	esc_html__( "Choose width for side menu area.", 'hudson' ),
	array(
		"width_290" => esc_html__( "290px", 'hudson' ),
		"width_350" => esc_html__( "350px", 'hudson' ),
		"width_400" => esc_html__( "400px", 'hudson' )
	)
);
$panel7->addChild(
	"vertical_area_width",
	$vertical_area_width
);

$vertical_area_position = new HudsonEdgeField(
	"select",
	"vertical_area_position",
	"left",
	esc_html__( "Side Menu Area Position", 'hudson' ),
	esc_html__( "Choose side menu position relative to browser screen", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$panel7->addChild(
	"vertical_area_position",
	$vertical_area_position
);

$vertical_area_dropdown_showing = new HudsonEdgeField(
	"select",
	"vertical_area_dropdown_showing",
	"hover",
	esc_html__( "Submenu Opening Behaviour", 'hudson' ),
	esc_html__( "Specify 2nd and 3rd level menu opening style", 'hudson' ),
	array(
		"hover" => esc_html__( "On Hover", 'hudson' ),
		"click" => esc_html__( "On Click", 'hudson' ),
		"side" => esc_html__( "Slide In", 'hudson' ),
		"to_content" => esc_html__( "Float", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"hover"      => "#edgtf_vertical_area_dropdown_background_container, #edgtf_vertical_menu_dd_separator_container",
			"click"      => "#edgtf_vertical_area_dropdown_background_container, #edgtf_vertical_menu_dd_separator_container",
			"side"       => "#edgtf_vertical_area_transparency_container, #edgtf_vertical_area_background_container, #edgtf_vertical_area_dropdown_background_container, #edgtf_vertical_menu_dd_separator_container",
			"to_content" => ""
		),
		"show"       => array(
			"hover"      => "#edgtf_vertical_area_transparency_container, #edgtf_vertical_area_background_container",
			"click"      => "#edgtf_vertical_area_transparency_container, #edgtf_vertical_area_background_container",
			"side"       => "",
			"to_content" => "#edgtf_vertical_area_transparency_container, #edgtf_vertical_area_background_container, #edgtf_vertical_area_dropdown_background_container, #edgtf_vertical_menu_dd_separator_container"
		)
	)
);

$panel7->addChild(
	"vertical_area_dropdown_showing",
	$vertical_area_dropdown_showing
);

$vertical_area_nav_in_middle = new HudsonEdgeField(
	"yesno",
	"vertical_area_nav_in_middle",
	"no",
	esc_html__( "Vertically Align Navigation to Middle", 'hudson' ),
	esc_html__( "Enabling this option will vertically align main menu to the middle of the side menu area and set widget area on the bottom. Note that you need to use 'float' type of submenu opening behavior", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_vertical_area_dropdown_showing",
		"dependence_show_on_yes" => ""
	)
);
$panel7->addChild(
	"vertical_area_nav_in_middle",
	$vertical_area_nav_in_middle
);

$vertical_area_background = new HudsonEdgeField(
	"color",
	"vertical_area_background",
	"",
	esc_html__( "Side Menu Area Background Color", 'hudson' ),
	esc_html__( "Choose a color for Side Menu Area background", 'hudson' )
);
$panel7->addChild(
	"vertical_area_background",
	$vertical_area_background
);

$vertical_area_transparency_container = new HudsonEdgeContainer(
	"vertical_area_transparency_container",
	"vertical_area_dropdown_showing",
	"side"
);
$panel7->addChild(
	"vertical_area_transparency_container",
	$vertical_area_transparency_container
);

$vertical_area_background_transparency = new HudsonEdgeField(
	"text",
	"vertical_area_background_transparency",
	"",
	esc_html__( "Side Menu Area Background Opacity", 'hudson' ),
	esc_html__( "Choose a opacity for the Side Menu Area Background (0 = fully transparent, 1 = opaque)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$vertical_area_transparency_container->addChild(
	"vertical_area_background_transparency",
	$vertical_area_background_transparency
);

$vertical_area_background_container = new HudsonEdgeContainer(
	"vertical_area_background_container",
	"vertical_area_dropdown_showing",
	"side"
);
$vertical_area_transparency_container->addChild(
	"vertical_area_background_container",
	$vertical_area_background_container
);

$vertical_area_background_image = new HudsonEdgeField(
	"image",
	"vertical_area_background_image",
	"",
	esc_html__( "Side Menu Area Background Image", 'hudson' ),
	esc_html__( "Choose an image for Side Menu background", 'hudson' )
);
$vertical_area_background_container->addChild(
	"vertical_area_background_image",
	$vertical_area_background_image
);

$vertical_area_transparency_over_slider = new HudsonEdgeField(
	"yesno",
	"vertical_area_transparency_over_slider",
	"no",
	esc_html__( "Transparency Setting Takes Effect Only on Edge Slider", 'hudson' ),
	esc_html__( "Enabling this option will ensure that the transparency set in the 'Side Menu Area Background Opacity' takes effect only when the side menu area is over the Edge Slider", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => ""
	)
);
$vertical_area_transparency_container->addChild(
	"vertical_area_transparency_over_slider",
	$vertical_area_transparency_over_slider
);

$vertical_area_transparency = new HudsonEdgeField(
	"yesno",
	"vertical_area_transparency",
	"no",
	esc_html__( "Enable Fully Transparent Side Menu Area Over Edge Slider", 'hudson' ),
	esc_html__( "Enabling this option will make Side Menu Area background over Edge Slider fully transparent", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_vertical_area_transparency_fonts_container"
	)
);
$vertical_area_transparency_container->addChild(
	"vertical_area_transparency",
	$vertical_area_transparency
);

$vertical_area_transparency_fonts_container = new HudsonEdgeContainer(
	"vertical_area_transparency_fonts_container",
	"vertical_area_transparency",
	"no"
);
$vertical_area_transparency_container->addChild(
	"vertical_area_transparency_fonts_container",
	$vertical_area_transparency_fonts_container
);

$group1 = new HudsonEdgeGroup(
	"1st Level Transparent Menu Style",
	esc_html__( "Define styles for 1st level in Transparent Side Menu", 'hudson' )
);
$vertical_area_transparency_fonts_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$vertical_transparent_menu_color = new HudsonEdgeField(
	"colorsimple",
	"vertical_transparent_menu_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_transparent_menu_color",
	$vertical_transparent_menu_color
);
$vertical_transparent_menu_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_transparent_menu_hovercolor",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_transparent_menu_hovercolor",
	$vertical_transparent_menu_hovercolor
);
$vertical_transparent_menu_activecolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_transparent_menu_activecolor",
	"",
	esc_html__( "Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_transparent_menu_activecolor",
	$vertical_transparent_menu_activecolor
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);

$vertical_transparent_menu_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"vertical_transparent_menu_google_fonts",
	"-1",
	esc_html__( "Font family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_menu_google_fonts",
	$vertical_transparent_menu_google_fonts
);
$vertical_transparent_menu_fontsize = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_menu_fontsize",
	"",
	esc_html__( "Font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_menu_fontsize",
	$vertical_transparent_menu_fontsize
);
$vertical_transparent_menu_lineheight = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_menu_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_menu_lineheight",
	$vertical_transparent_menu_lineheight
);

$row3 = new HudsonEdgeRow( true );
$group1->addChild(
	"row3",
	$row3
);

$vertical_transparent_menu_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_menu_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"vertical_transparent_menu_fontstyle",
	$vertical_transparent_menu_fontstyle
);
$vertical_transparent_menu_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_menu_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"vertical_transparent_menu_fontweight",
	$vertical_transparent_menu_fontweight
);
$vertical_transparent_menu_letterspacing = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_menu_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"vertical_transparent_menu_letterspacing",
	$vertical_transparent_menu_letterspacing
);
$vertical_transparent_menu_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_menu_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"vertical_transparent_menu_texttransform",
	$vertical_transparent_menu_texttransform
);

$group2 = new HudsonEdgeGroup(
	"2nd Level Transparent Menu Style",
	esc_html__( "Define styles for 2nd level in Transparent Side Menu", 'hudson' )
);
$vertical_area_transparency_fonts_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$vertical_transparent_dropdown_color = new HudsonEdgeField(
	"colorsimple",
	"vertical_transparent_dropdown_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_transparent_dropdown_color",
	$vertical_transparent_dropdown_color
);
$vertical_transparent_dropdown_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_transparent_dropdown_hovercolor",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_transparent_dropdown_hovercolor",
	$vertical_transparent_dropdown_hovercolor
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);

$vertical_transparent_dropdown_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"vertical_transparent_dropdown_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_dropdown_google_fonts",
	$vertical_transparent_dropdown_google_fonts
);
$vertical_transparent_dropdown_fontsize = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_dropdown_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_dropdown_fontsize",
	$vertical_transparent_dropdown_fontsize
);
$vertical_transparent_dropdown_lineheight = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_dropdown_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_dropdown_lineheight",
	$vertical_transparent_dropdown_lineheight
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);

$vertical_transparent_dropdown_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_dropdown_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"vertical_transparent_dropdown_fontstyle",
	$vertical_transparent_dropdown_fontstyle
);
$vertical_transparent_dropdown_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_dropdown_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"vertical_transparent_dropdown_fontweight",
	$vertical_transparent_dropdown_fontweight
);
$vertical_transparent_dropdown_letterspacing = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_dropdown_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"vertical_transparent_dropdown_letterspacing",
	$vertical_transparent_dropdown_letterspacing
);
$vertical_transparent_dropdown_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_dropdown_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"vertical_transparent_dropdown_texttransform",
	$vertical_transparent_dropdown_texttransform
);

$group3 = new HudsonEdgeGroup(
	"3rd Level Transparent Menu Style",
	esc_html__( "Define styles for 3rd level in Transparent Side Menu", 'hudson' )
);
$vertical_area_transparency_fonts_container->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$vertical_transparent_dropdown_color_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"vertical_transparent_dropdown_color_thirdlvl",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_transparent_dropdown_color_thirdlvl",
	$vertical_transparent_dropdown_color_thirdlvl
);
$vertical_transparent_dropdown_hovercolor_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"vertical_transparent_dropdown_hovercolor_thirdlvl",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_transparent_dropdown_hovercolor_thirdlvl",
	$vertical_transparent_dropdown_hovercolor_thirdlvl
);

$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);

$vertical_transparent_dropdown_google_fonts_thirdlvl = new HudsonEdgeField(
	"fontsimple",
	"vertical_transparent_dropdown_google_fonts_thirdlvl",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_dropdown_google_fonts_thirdlvl",
	$vertical_transparent_dropdown_google_fonts_thirdlvl
);
$vertical_transparent_dropdown_fontsize_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_dropdown_fontsize_thirdlvl",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_dropdown_fontsize_thirdlvl",
	$vertical_transparent_dropdown_fontsize_thirdlvl
);
$vertical_transparent_dropdown_lineheight_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_dropdown_lineheight_thirdlvl",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_transparent_dropdown_lineheight_thirdlvl",
	$vertical_transparent_dropdown_lineheight_thirdlvl
);

$row3 = new HudsonEdgeRow( true );
$group3->addChild(
	"row3",
	$row3
);

$vertical_transparent_dropdown_fontstyle_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_dropdown_fontstyle_thirdlvl",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"vertical_transparent_dropdown_fontstyle_thirdlvl",
	$vertical_transparent_dropdown_fontstyle_thirdlvl
);
$vertical_transparent_dropdown_fontweight_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_dropdown_fontweight_thirdlvl",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"vertical_transparent_dropdown_fontweight_thirdlvl",
	$vertical_transparent_dropdown_fontweight_thirdlvl
);
$vertical_transparent_dropdown_letterspacing_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"vertical_transparent_dropdown_letterspacing_thirdlvl",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"vertical_transparent_dropdown_letterspacing_thirdlvl",
	$vertical_transparent_dropdown_letterspacing_thirdlvl
);
$vertical_transparent_dropdown_texttransform_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_transparent_dropdown_texttransform_thirdlvl",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"vertical_transparent_dropdown_texttransform_thirdlvl",
	$vertical_transparent_dropdown_texttransform_thirdlvl
);

$vertical_area_dropdown_background_container = new HudsonEdgeContainer(
	"vertical_area_dropdown_background_container",
	"vertical_area_dropdown_showing",
	"side",
	array( "side", "hover", "click" )
);
$panel7->addChild(
	"vertical_area_dropdown_background_container",
	$vertical_area_dropdown_background_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Dropdown Menu Background", 'hudson' ),
	esc_html__( "Choose Background for dropdown menu", 'hudson' )
);
$vertical_area_dropdown_background_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$vertical_area_dropdown_menu_bckg_color = new HudsonEdgeField(
	"colorsimple",
	"vertical_area_dropdown_menu_bckg_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_area_dropdown_menu_bckg_color",
	$vertical_area_dropdown_menu_bckg_color
);

$vertical_area_dropdown_menu_bckg_opacity = new HudsonEdgeField(
	"textsimple",
	"vertical_area_dropdown_menu_bckg_opacity",
	"",
	esc_html__( "Opacity (0-1)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_area_dropdown_menu_bckg_opacity",
	$vertical_area_dropdown_menu_bckg_opacity
);

$vertical_area_menu_items_arrow = new HudsonEdgeField(
	"yesno",
	"vertical_area_menu_items_arrow",
	"no",
	"2nd level menu arrow shape",
	esc_html__( "Enabling this option will display arrow shape on 2nd level menu", 'hudson' )
);
$vertical_area_dropdown_background_container->addChild(
	"vertical_area_menu_items_arrow",
	$vertical_area_menu_items_arrow
);

$vertical_area_padding = new HudsonEdgeField(
	"text",
	"vertical_area_padding",
	"",
	esc_html__( "Side Menu Area Padding", 'hudson' ),
	esc_html__( "Set padding for Side Menu Area in pixels (default value is 20px 40px 20px 40px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel7->addChild(
	"vertical_area_padding",
	$vertical_area_padding
);

$vertical_area_navigation_top_margin = new HudsonEdgeField(
	"text",
	"vertical_area_navigation_top_margin",
	"",
	esc_html__( "Navigation Top Margin", 'hudson' ),
	esc_html__( "Set the space between logo and navigation in pixels (default value is 40px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel7->addChild(
	"vertical_area_navigation_top_margin",
	$vertical_area_navigation_top_margin
);

$vertical_area_text_color = new HudsonEdgeField(
	"color",
	"vertical_area_text_color",
	"",
	esc_html__( "Side Menu Area Text Color (for Widgets)", 'hudson' ),
	esc_html__( "Choose a text color for widgets in Side Menu", 'hudson' )
);
$panel7->addChild(
	"vertical_area_text_color",
	$vertical_area_text_color
);

$vertical_area_alignment = new HudsonEdgeField(
	"selectblank",
	"vertical_area_alignment",
	"",
	esc_html__( "Side Menu Area Aligment", 'hudson' ),
	esc_html__( "Specify alignment for logo, menu and widgets.", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$panel7->addChild(
	"vertical_area_alignment",
	$vertical_area_alignment
);

$vertical_area_right_border_color = new HudsonEdgeField(
	"color",
	"vertical_area_right_border_color",
	"",
	esc_html__( "Side Menu Area Right Border Color", 'hudson' ),
	esc_html__( "Choose a color for right border of side menu area", 'hudson' )
);
$panel7->addChild(
	"vertical_area_right_border_color",
	$vertical_area_right_border_color
);

$vertical_menu_submenu_sign = new HudsonEdgeField(
	"yesno",
	"vertical_menu_submenu_sign",
	"yes",
	esc_html__( "Enable Plus Sign", 'hudson' ),
	esc_html__( "Enable dropdown plus sign", 'hudson' )
);
$panel7->addChild(
	"vertical_menu_submenu_sign",
	$vertical_menu_submenu_sign
);

$vertical_menu_first_level = new HudsonEdgeTitle(
	"vertical_menu_first_level",
	esc_html__( "First Level Menu", 'hudson' )
);
$panel7->addChild(
	"vertical_menu_first_level",
	$vertical_menu_first_level
);

$vertical_area_menu_items_padding = new HudsonEdgeField(
	"text",
	"vertical_area_menu_items_padding",
	"",
	esc_html__( "Menu Items Top/Bottom Padding", 'hudson' ),
	esc_html__( "Enter padding for top and bottom of menu items in menu first level (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel7->addChild(
	"vertical_area_menu_items_padding",
	$vertical_area_menu_items_padding
);

$full_width_vertical_menu_items = new HudsonEdgeField(
	"yesno",
	"full_width_vertical_menu_items",
	"no",
	esc_html__( "Full Width Menu Items", 'hudson' ),
	esc_html__( "Enabling this option will set menu item area to full width of vertical menu", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_vertical_menu_separators_width_container",
		"dependence_show_on_yes" => "#edgtf_vertical_menu_top_bottom_separators_container"
	)
);
$panel7->addChild(
	"full_width_vertical_menu_items",
	$full_width_vertical_menu_items
);

$enable_vertical_menu_separators = new HudsonEdgeField(
	"yesno",
	"enable_vertical_menu_separators",
	"no",
	esc_html__( "Enable Menu Item Separators", 'hudson' ),
	esc_html__( "Enabling this option will display menu item separators", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_vertical_menu_separators_container"
	)
);
$panel7->addChild(
	"enable_vertical_menu_separators",
	$enable_vertical_menu_separators
);

$vertical_menu_separators_container = new HudsonEdgeContainer(
	"vertical_menu_separators_container",
	"enable_vertical_menu_separators",
	"no"
);
$panel7->addChild(
	"vertical_menu_separators_container",
	$vertical_menu_separators_container
);

$vertical_menu_separators_width_container = new HudsonEdgeContainer(
	"vertical_menu_separators_width_container",
	"full_width_vertical_menu_items",
	"yes"
);
$vertical_menu_separators_container->addChild(
	"vertical_menu_separators_width_container",
	$vertical_menu_separators_width_container
);

$vertical_menu_separators_width = new HudsonEdgeField(
	"text",
	"vertical_menu_separators_width",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "Enter width for the separators", 'hudson' ),
	array(),
	array( "col_width" => 1 )
);
$vertical_menu_separators_width_container->addChild(
	"vertical_menu_separators_width",
	$vertical_menu_separators_width
);

$vertical_menu_separators_color = new HudsonEdgeField(
	"color",
	"vertical_menu_separators_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color for the menu item separators.", 'hudson' )
);
$vertical_menu_separators_container->addChild(
	"vertical_menu_separators_color",
	$vertical_menu_separators_color
);

$vertical_menu_top_bottom_separators_container = new HudsonEdgeContainer(
	"vertical_menu_top_bottom_separators_container",
	"full_width_vertical_menu_items",
	"no"
);
$vertical_menu_separators_container->addChild(
	"vertical_menu_top_bottom_separators_container",
	$vertical_menu_top_bottom_separators_container
);

$enable_vertical_menutop_bottom_separators = new HudsonEdgeField(
	"yesno",
	"enable_vertical_menutop_bottom_separators",
	"no",
	esc_html__( "Enable Menu Top and Bottom Separators", 'hudson' ),
	esc_html__( "Enabling this option will display separators at top and bottom of menu also", 'hudson' )
);
$vertical_menu_top_bottom_separators_container->addChild(
	"enable_vertical_menutop_bottom_separators",
	$enable_vertical_menutop_bottom_separators
);

$enable_vertical_menu_items_background = new HudsonEdgeField(
	"yesno",
	"enable_vertical_menu_items_background",
	"no",
	esc_html__( "Enable Background for 1st Level Menu Items", 'hudson' ),
	esc_html__( "Enable this option and choose background color for items in first level menu", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_vertical_menu_items_background_container"
	)
);
$panel7->addChild(
	"enable_vertical_menu_items_background",
	$enable_vertical_menu_items_background
);

$vertical_menu_items_background_container = new HudsonEdgeContainer(
	"vertical_menu_items_background_container",
	"enable_vertical_menu_items_background",
	"no"
);
$panel7->addChild(
	"vertical_menu_items_background_container",
	$vertical_menu_items_background_container
);

$vertical_menu_items_background_color = new HudsonEdgeField(
	"color",
	"vertical_menu_items_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a background color for the menu items", 'hudson' )
);
$vertical_menu_items_background_container->addChild(
	"vertical_menu_items_background_color",
	$vertical_menu_items_background_color
);

$vertical_menu_items_hover_background_color = new HudsonEdgeField(
	"color",
	"vertical_menu_items_hover_background_color",
	"",
	esc_html__( "Hover Background Color", 'hudson' ),
	esc_html__( "Choose a background color for the hover menu items", 'hudson' )
);
$vertical_menu_items_background_container->addChild(
	"vertical_menu_items_hover_background_color",
	$vertical_menu_items_hover_background_color
);

$vertical_menu_items_active_background_color = new HudsonEdgeField(
	"color",
	"vertical_menu_items_active_background_color",
	"",
	esc_html__( "Active Background Color", 'hudson' ),
	esc_html__( "Choose a background color for the active menu items", 'hudson' )
);
$vertical_menu_items_background_container->addChild(
	"vertical_menu_items_active_background_color",
	$vertical_menu_items_active_background_color
);

$enable_vertical_menu_item_left_border_container = new HudsonEdgeContainer(
	"enable_vertical_menu_item_left_border_container",
	"vertical_area_type",
	"hidden_with_icons"
);
$panel7->addChild(
	"enable_vertical_menu_item_left_border_container",
	$enable_vertical_menu_item_left_border_container
);

$enable_vertical_menu_item_left_border = new HudsonEdgeField(
	"yesno",
	"enable_vertical_menu_item_left_border",
	"no",
	esc_html__( "Enable Left Border for 1st Level Menu Items", 'hudson' ),
	esc_html__( "Enabling this option will display left border in first level menu items", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_vertical_menu_item_left_border_container"
	)
);
$enable_vertical_menu_item_left_border_container->addChild(
	"enable_vertical_menu_item_left_border",
	$enable_vertical_menu_item_left_border
);

$vertical_menu_item_left_border_container = new HudsonEdgeContainer(
	"vertical_menu_item_left_border_container",
	"enable_vertical_menu_item_left_border",
	"no"
);
$panel7->addChild(
	"vertical_menu_item_left_border_container",
	$vertical_menu_item_left_border_container
);

$vertical_menu_item_left_border_width = new HudsonEdgeField(
	"text",
	"vertical_menu_item_left_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "Enter width for the menu item border", 'hudson' ),
	array(),
	array( "col_width" => 1 )
);
$vertical_menu_item_left_border_container->addChild(
	"vertical_menu_item_left_border_width",
	$vertical_menu_item_left_border_width
);

$vertical_menu_item_left_border_color = new HudsonEdgeField(
	"color",
	"vertical_menu_item_left_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "Choose a color for the menu item border", 'hudson' )
);
$vertical_menu_item_left_border_container->addChild(
	"vertical_menu_item_left_border_color",
	$vertical_menu_item_left_border_color
);

$vertical_menu_item_left_border_hover_color = new HudsonEdgeField(
	"color",
	"vertical_menu_item_left_border_hover_color",
	"",
	esc_html__( "Border Hover Color", 'hudson' ),
	esc_html__( "Choose a hover color for the menu item border", 'hudson' )
);
$vertical_menu_item_left_border_container->addChild(
	"vertical_menu_item_left_border_hover_color",
	$vertical_menu_item_left_border_hover_color
);

$vertical_menu_item_left_border_active_color = new HudsonEdgeField(
	"color",
	"vertical_menu_item_left_border_active_color",
	"",
	esc_html__( "Border Active Color", 'hudson' ),
	esc_html__( "Choose a color for the active menu item border", 'hudson' )
);
$vertical_menu_item_left_border_container->addChild(
	"vertical_menu_item_left_border_active_color",
	$vertical_menu_item_left_border_active_color
);

$enable_vertical_menu_item_text_decoration = new HudsonEdgeField(
	"yesno",
	"enable_vertical_menu_item_text_decoration",
	"no",
	esc_html__( "Enable 1st Level Menu Item Text Decoration", 'hudson' ),
	esc_html__( "Enable this option and choose a text decoration for menu items in first level", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_vertical_menu_item_text_decoration_container"
	)
);
$panel7->addChild(
	"enable_vertical_menu_item_text_decoration",
	$enable_vertical_menu_item_text_decoration
);

$vertical_menu_item_text_decoration_container = new HudsonEdgeContainer(
	"vertical_menu_item_text_decoration_container",
	"enable_vertical_menu_item_text_decoration",
	"no"
);
$panel7->addChild(
	"vertical_menu_item_text_decoration_container",
	$vertical_menu_item_text_decoration_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Menu Item Text Decoration", 'hudson' ),
	""
);
$vertical_menu_item_text_decoration_container->addChild(
	"group1",
	$group1
);
$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$vertical_menu_item_text_decoration_style = new HudsonEdgeField(
	"selectsimple",
	"vertical_menu_item_text_decoration_style",
	"none",
	esc_html__( "Hover Item Text Decoration", 'hudson' ),
	esc_html__( "Choose text decoration type for hover menu items", 'hudson' ),
	array(
		"none" => esc_html__( "None", 'hudson' ),
		"underline" => esc_html__( "Underline", 'hudson' ),
		"line-through" => esc_html__( "Line-through", 'hudson' ),
		"overline" => esc_html__( "Overline", 'hudson' )
	)
);
$row1->addChild(
	"vertical_menu_item_text_decoration_style",
	$vertical_menu_item_text_decoration_style
);

$vertical_menu_item_active_text_decoration_style = new HudsonEdgeField(
	"selectsimple",
	"vertical_menu_item_active_text_decoration_style",
	"none",
	esc_html__( "Active Item Text Decoration", 'hudson' ),
	esc_html__( "Choose text decoration type for active menu items", 'hudson' ),
	array(
		"none" => esc_html__( "None", 'hudson' ),
		"underline" => esc_html__( "Underline", 'hudson' ),
		"line-through" => esc_html__( "Line-through", 'hudson' ),
		"overline" => esc_html__( "Overline", 'hudson' )
	)
);
$row1->addChild(
	"vertical_menu_item_active_text_decoration_style",
	$vertical_menu_item_active_text_decoration_style
);

$enable_vertical_menu_item_border = new HudsonEdgeField(
	"yesno",
	"enable_vertical_menu_item_border",
	"no",
	esc_html__( "Enable Hover Borders for 1st Level Menu Items", 'hudson' ),
	esc_html__( "Enabling this option will show borders on hover around item text in first level menu. In order to work, you need to set border width and color.", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_vertical_menu_item_border_container"
	)
);
$panel7->addChild(
	"enable_vertical_menu_item_border",
	$enable_vertical_menu_item_border
);

$vertical_menu_item_border_container = new HudsonEdgeContainer(
	"vertical_menu_item_border_container",
	"enable_vertical_menu_item_border",
	"no"
);
$panel7->addChild(
	"vertical_menu_item_border_container",
	$vertical_menu_item_border_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Hover Border Style", 'hudson' ),
	""
);
$vertical_menu_item_border_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$vertical_menu_item_border_width = new HudsonEdgeField(
	"textsimple",
	"vertical_menu_item_border_width",
	"",
	esc_html__( "Border Width", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_menu_item_border_width",
	$vertical_menu_item_border_width
);

$vertical_menu_item_border_hover = new HudsonEdgeField(
	"colorsimple",
	"vertical_menu_item_border_hover",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_menu_item_border_hover",
	$vertical_menu_item_border_hover
);

$vertical_menu_item_border_active = new HudsonEdgeField(
	"colorsimple",
	"vertical_menu_item_border_active",
	"",
	esc_html__( "Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_menu_item_border_active",
	$vertical_menu_item_border_active
);

$vertical_menu_dropdown = new HudsonEdgeTitle(
	"vertical_menu_dropdown",
	esc_html__( "Second Level Menu", 'hudson' )
);
$panel7->addChild(
	"vertical_menu_dropdown",
	$vertical_menu_dropdown
);

$vertical_menu_dropdown_top_padding = new HudsonEdgeField(
	"text",
	"vertical_menu_dropdown_top_padding",
	"",
	esc_html__( "Dropdown Top Padding", 'hudson' ),
	esc_html__( "Enter top padding for dropdown (in pixels)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel7->addChild(
	"vertical_menu_dropdown_top_padding",
	$vertical_menu_dropdown_top_padding
);

$vertical_menu_dropdown_bottom_padding = new HudsonEdgeField(
	"text",
	"vertical_menu_dropdown_bottom_padding",
	"",
	esc_html__( "Dropdown Bottom Padding", 'hudson' ),
	esc_html__( "Enter bottom padding for dropdown (in pixels)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel7->addChild(
	"vertical_menu_dropdown_bottom_padding",
	$vertical_menu_dropdown_bottom_padding
);

$vertical_menu_dd_item_padding_top_bttm = new HudsonEdgeField(
	"text",
	"vertical_menu_dd_item_padding_top_bttm",
	"",
	esc_html__( "Dropdown Menu Items Top/Bottom Padding", 'hudson' ),
	esc_html__( "Enter padding for top and bottom of menu items in submenu dropdown (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel7->addChild(
	"vertical_menu_dd_item_padding_top_bttm",
	$vertical_menu_dd_item_padding_top_bttm
);

$vertical_menu_dropdown_plus_color = new HudsonEdgeField(
	"color",
	"vertical_menu_dropdown_plus_color",
	"",
	esc_html__( "Dropdown 'Plus' Icon Color", 'hudson' ),
	esc_html__( "Choose a color for dropdown 'plus' icon", 'hudson' )
);
$panel7->addChild(
	"vertical_menu_dropdown_plus_color",
	$vertical_menu_dropdown_plus_color
);

$vertical_menu_dd_separator_container = new HudsonEdgeContainer(
	"vertical_menu_dd_separator_container",
	"vertical_area_dropdown_showing",
	"hover",
	array( "hover", "side", "click" )
);
$panel7->addChild(
	"vertical_menu_dd_separator_container",
	$vertical_menu_dd_separator_container
);

$vertical_dropdown_separators_yesno = new HudsonEdgeField(
	"yesno",
	"vertical_dropdown_separators_yesno",
	"no",
	esc_html__( "Enable Dropdown Menu Item Separators", 'hudson' ),
	esc_html__( "Enabling this option will display dropdown menu item separators", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_vertical_dropdown_separators_container"
	)
);
$vertical_menu_dd_separator_container->addChild(
	"vertical_dropdown_separators_yesno",
	$vertical_dropdown_separators_yesno
);

$vertical_dropdown_separators_container = new HudsonEdgeContainer(
	"vertical_dropdown_separators_container",
	"vertical_dropdown_separators_yesno",
	"no"
);
$vertical_menu_dd_separator_container->addChild(
	"vertical_dropdown_separators_container",
	$vertical_dropdown_separators_container
);

$vertical_dropdown_separators_color = new HudsonEdgeField(
	"color",
	"vertical_dropdown_separators_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color for the menu item separators.", 'hudson' )
);
$vertical_dropdown_separators_container->addChild(
	"vertical_dropdown_separators_color",
	$vertical_dropdown_separators_color
);

$enable_vertical_top_bottom_dropdown_separators = new HudsonEdgeField(
	"yesno",
	"enable_vertical_top_bottom_dropdown_separators",
	"no",
	esc_html__( "Enable Menu Top and Bottom Separators", 'hudson' ),
	esc_html__( "Enabling this option will display separators at top and bottom of menu also", 'hudson' )
);
$vertical_dropdown_separators_container->addChild(
	"enable_vertical_top_bottom_dropdown_separators",
	$enable_vertical_top_bottom_dropdown_separators
);

$vertical_menu_text_icons = new HudsonEdgeTitle(
	"vertical_menu_text_icons",
	esc_html__( "Menu Text and Icons", 'hudson' )
);
$panel7->addChild(
	"vertical_menu_text_icons",
	$vertical_menu_text_icons
);

$group1 = new HudsonEdgeGroup(
	"1st Level Menu Style",
	esc_html__( "Define styles for 1st level in Side Menu", 'hudson' )
);
$panel7->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$vertical_menu_color = new HudsonEdgeField(
	"colorsimple",
	"vertical_menu_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_menu_color",
	$vertical_menu_color
);
$vertical_menu_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_menu_hovercolor",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_menu_hovercolor",
	$vertical_menu_hovercolor
);
$vertical_menu_activecolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_menu_activecolor",
	"",
	esc_html__( "Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_menu_activecolor",
	$vertical_menu_activecolor
);

$row4 = new HudsonEdgeRow();
$group1->addChild(
	"row4",
	$row4
);

$vertical_menu_icon_color = new HudsonEdgeField(
	"colorsimple",
	"vertical_menu_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"vertical_menu_icon_color",
	$vertical_menu_icon_color
);
$vertical_menu_icon_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_menu_icon_hovercolor",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"vertical_menu_icon_hovercolor",
	$vertical_menu_icon_hovercolor
);
$vertical_menu_icon_activecolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_menu_icon_activecolor",
	"",
	esc_html__( "Icon Active Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"vertical_menu_icon_activecolor",
	$vertical_menu_icon_activecolor
);
$vertical_menu_icon_margin = new HudsonEdgeField(
	"textsimple",
	"vertical_menu_icon_margin",
	"",
	esc_html__( "Space between text and icon (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"vertical_menu_icon_margin",
	$vertical_menu_icon_margin
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);

$vertical_menu_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"vertical_menu_google_fonts",
	"-1",
	esc_html__( "Font family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_menu_google_fonts",
	$vertical_menu_google_fonts
);
$vertical_menu_fontsize = new HudsonEdgeField(
	"textsimple",
	"vertical_menu_fontsize",
	"",
	esc_html__( "Font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_menu_fontsize",
	$vertical_menu_fontsize
);
$vertical_menu_icon_fontsize = new HudsonEdgeField(
	"textsimple",
	"vertical_menu_icon_fontsize",
	"",
	esc_html__( "Icon font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_menu_icon_fontsize",
	$vertical_menu_icon_fontsize
);
$vertical_menu_lineheight = new HudsonEdgeField(
	"textsimple",
	"vertical_menu_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_menu_lineheight",
	$vertical_menu_lineheight
);

$row3 = new HudsonEdgeRow( true );
$group1->addChild(
	"row3",
	$row3
);

$vertical_menu_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_menu_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"vertical_menu_fontstyle",
	$vertical_menu_fontstyle
);
$vertical_menu_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_menu_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"vertical_menu_fontweight",
	$vertical_menu_fontweight
);
$vertical_menu_letterspacing = new HudsonEdgeField(
	"textsimple",
	"vertical_menu_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"vertical_menu_letterspacing",
	$vertical_menu_letterspacing
);
$vertical_menu_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_menu_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"vertical_menu_texttransform",
	$vertical_menu_texttransform
);

$group2 = new HudsonEdgeGroup(
	"2nd Level Menu Style",
	esc_html__( "Define styles for 2nd level in Side Menu", 'hudson' )
);
$panel7->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$vertical_dropdown_color = new HudsonEdgeField(
	"colorsimple",
	"vertical_dropdown_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_dropdown_color",
	$vertical_dropdown_color
);
$vertical_dropdown_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_dropdown_hovercolor",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_dropdown_hovercolor",
	$vertical_dropdown_hovercolor
);

$row4 = new HudsonEdgeRow();
$group2->addChild(
	"row4",
	$row4
);
$vertical_dropdown_icon_color = new HudsonEdgeField(
	"colorsimple",
	"vertical_dropdown_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"vertical_dropdown_icon_color",
	$vertical_dropdown_icon_color
);
$vertical_dropdown_icon_hovercolor = new HudsonEdgeField(
	"colorsimple",
	"vertical_dropdown_icon_hovercolor",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"vertical_dropdown_icon_hovercolor",
	$vertical_dropdown_icon_hovercolor
);

$row2 = new HudsonEdgeRow( true );
$group2->addChild(
	"row2",
	$row2
);

$vertical_dropdown_google_fonts = new HudsonEdgeField(
	"fontsimple",
	"vertical_dropdown_google_fonts",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_dropdown_google_fonts",
	$vertical_dropdown_google_fonts
);
$vertical_dropdown_fontsize = new HudsonEdgeField(
	"textsimple",
	"vertical_dropdown_fontsize",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_dropdown_fontsize",
	$vertical_dropdown_fontsize
);
$vertical_dropdown_icon_fontsize = new HudsonEdgeField(
	"textsimple",
	"vertical_dropdown_icon_fontsize",
	"",
	esc_html__( "Icon font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_dropdown_icon_fontsize",
	$vertical_dropdown_icon_fontsize
);
$vertical_dropdown_lineheight = new HudsonEdgeField(
	"textsimple",
	"vertical_dropdown_lineheight",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_dropdown_lineheight",
	$vertical_dropdown_lineheight
);

$row3 = new HudsonEdgeRow( true );
$group2->addChild(
	"row3",
	$row3
);

$vertical_dropdown_fontstyle = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_dropdown_fontstyle",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"vertical_dropdown_fontstyle",
	$vertical_dropdown_fontstyle
);
$vertical_dropdown_fontweight = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_dropdown_fontweight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"vertical_dropdown_fontweight",
	$vertical_dropdown_fontweight
);
$vertical_dropdown_letterspacing = new HudsonEdgeField(
	"textsimple",
	"vertical_dropdown_letterspacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"vertical_dropdown_letterspacing",
	$vertical_dropdown_letterspacing
);
$vertical_dropdown_texttransform = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_dropdown_texttransform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"vertical_dropdown_texttransform",
	$vertical_dropdown_texttransform
);

$group3 = new HudsonEdgeGroup(
	"3rd Level Menu Style",
	esc_html__( "Define styles for 3rd level in Side Menu", 'hudson' )
);
$panel7->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	"row1",
	$row1
);

$vertical_dropdown_color_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"vertical_dropdown_color_thirdlvl",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_dropdown_color_thirdlvl",
	$vertical_dropdown_color_thirdlvl
);
$vertical_dropdown_hovercolor_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"vertical_dropdown_hovercolor_thirdlvl",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"vertical_dropdown_hovercolor_thirdlvl",
	$vertical_dropdown_hovercolor_thirdlvl
);

$row4 = new HudsonEdgeRow();
$group3->addChild(
	"row4",
	$row4
);
$vertical_dropdown_icon_color_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"vertical_dropdown_icon_color_thirdlvl",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"vertical_dropdown_icon_color_thirdlvl",
	$vertical_dropdown_icon_color_thirdlvl
);
$vertical_dropdown_icon_hovercolor_thirdlvl = new HudsonEdgeField(
	"colorsimple",
	"vertical_dropdown_icon_hovercolor_thirdlvl",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"vertical_dropdown_icon_hovercolor_thirdlvl",
	$vertical_dropdown_icon_hovercolor_thirdlvl
);

$row2 = new HudsonEdgeRow( true );
$group3->addChild(
	"row2",
	$row2
);

$vertical_dropdown_google_fonts_thirdlvl = new HudsonEdgeField(
	"fontsimple",
	"vertical_dropdown_google_fonts_thirdlvl",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_dropdown_google_fonts_thirdlvl",
	$vertical_dropdown_google_fonts_thirdlvl
);
$vertical_dropdown_fontsize_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"vertical_dropdown_fontsize_thirdlvl",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_dropdown_fontsize_thirdlvl",
	$vertical_dropdown_fontsize_thirdlvl
);
$vertical_dropdown_icon_fontsize_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"vertical_dropdown_icon_fontsize_thirdlvl",
	"",
	esc_html__( "Icon font size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_dropdown_icon_fontsize_thirdlvl",
	$vertical_dropdown_icon_fontsize_thirdlvl
);
$vertical_dropdown_lineheight_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"vertical_dropdown_lineheight_thirdlvl",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"vertical_dropdown_lineheight_thirdlvl",
	$vertical_dropdown_lineheight_thirdlvl
);

$row3 = new HudsonEdgeRow( true );
$group3->addChild(
	"row3",
	$row3
);

$vertical_dropdown_fontstyle_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_dropdown_fontstyle_thirdlvl",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row3->addChild(
	"vertical_dropdown_fontstyle_thirdlvl",
	$vertical_dropdown_fontstyle_thirdlvl
);
$vertical_dropdown_fontweight_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_dropdown_fontweight_thirdlvl",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row3->addChild(
	"vertical_dropdown_fontweight_thirdlvl",
	$vertical_dropdown_fontweight_thirdlvl
);
$vertical_dropdown_letterspacing_thirdlvl = new HudsonEdgeField(
	"textsimple",
	"vertical_dropdown_letterspacing_thirdlvl",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row3->addChild(
	"vertical_dropdown_letterspacing_thirdlvl",
	$vertical_dropdown_letterspacing_thirdlvl
);
$vertical_dropdown_texttransform_thirdlvl = new HudsonEdgeField(
	"selectblanksimple",
	"vertical_dropdown_texttransform_thirdlvl",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"vertical_dropdown_texttransform_thirdlvl",
	$vertical_dropdown_texttransform_thirdlvl
);

//Mobile menu

$panel8 = new HudsonEdgePanel(
	esc_html__( "Mobile Header", 'hudson' ),
	"mobile_menu_panel"
);
$headerandfooterPage->addChild(
	"panel8",
	$panel8
);

$header_height_mobile = new HudsonEdgeField(
	"text",
	"header_height_mobile",
	"",
	esc_html__( "Mobile Header Height", 'hudson' ),
	esc_html__( "Enter height for mobile header in pixels", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel8->addChild(
	"header_height_mobile",
	$header_height_mobile
);

$mobile_separator_color = new HudsonEdgeField(
	"color",
	"mobile_separator_color",
	"",
	esc_html__( "Mobile Menu Item Separator Color", 'hudson' ),
	esc_html__( "Choose color for mobile menu horizontal separators", 'hudson' )
);
$panel8->addChild(
	"mobile_separator_color",
	$mobile_separator_color
);

$mobile_background_color = new HudsonEdgeField(
	"color",
	"mobile_background_color",
	"",
	esc_html__( "Mobile Header & Menu Background Color", 'hudson' ),
	esc_html__( "Choose color for mobile header&menu background", 'hudson' )
);
$panel8->addChild(
	"mobile_background_color",
	$mobile_background_color
);

$logo_mobile_header_height = new HudsonEdgeField(
	"text",
	"logo_mobile_header_height",
	"",
	esc_html__( "Logo Height For Mobile Header (px)", 'hudson' ),
	esc_html__( "Define logo height for screen size smaller than 1000px", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel8->addChild(
	"logo_mobile_header_height",
	$logo_mobile_header_height
);

$logo_mobile_height = new HudsonEdgeField(
	"text",
	"logo_mobile_height",
	"",
	esc_html__( "Logo Height For Mobile Devices (px)", 'hudson' ),
	esc_html__( "Define logo height for screen size smaller than 480px", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel8->addChild(
	"logo_mobile_height",
	$logo_mobile_height
);

$mobile_header_icon_pack = new HudsonEdgeField(
	'selectblank',
	'mobile_header_icon_pack',
	'default',
	esc_html__( 'Mobile Icon Pack', 'hudson' ),
	'Choose
                 Icon Pack',
	$hudson_edge_icon_collections->getIconCollectionsExclude( array( 'linea_icons', 'simple_line_icons' ) )
);
$panel8->addChild(
	'mobile_header_icon_pack',
	$mobile_header_icon_pack
);

// Header Button Icons
$panel9 = new HudsonEdgePanel(
	esc_html__( "Header Button Icons", 'hudson' ),
	"header_buttons_panel"
);
$headerandfooterPage->addChild(
	"panel9",
	$panel9
);

$header_icon_pack = new HudsonEdgeField(
	'select',
	'header_icon_pack',
	'font_awesome',
	esc_html__( 'Header Icons Icon Pack', 'hudson' ),
	'Choose
	 Icon Pack',
	$hudson_edge_icon_collections->getIconCollectionsExclude( array( 'linea_icons', 'simple_line_icons' ) )
);
$panel9->addChild(
	'header_icon_pack',
	$header_icon_pack
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Header Icons Style", 'hudson' ),
	esc_html__( "Define styles for header icons (Search Icon, Fullscreen Menu Icon and Side Area Icon)", 'hudson' )
);
$panel9->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow( true );
$group1->addChild(
	"row1",
	$row1
);

$header_buttons_color = new HudsonEdgeField(
	"colorsimple",
	"header_buttons_color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color for Header icons", 'hudson' )
);
$row1->addChild(
	"header_buttons_color",
	$header_buttons_color
);

$header_buttons_hover_color = new HudsonEdgeField(
	"colorsimple",
	"header_buttons_hover_color",
	"",
	esc_html__( "Hover Color", 'hudson' ),
	esc_html__( "Choose a hover color for Header icons", 'hudson' )
);
$row1->addChild(
	"header_buttons_hover_color",
	$header_buttons_hover_color
);

$row2 = new HudsonEdgeRow( true );
$group1->addChild(
	"row2",
	$row2
);

$header_light_icons_color = new HudsonEdgeField(
	"colorsimple",
	"header_light_icons_color",
	"",
	esc_html__( "Light Menu Icon Color", 'hudson' ),
	esc_html__( "Choose a color for Header Light icons", 'hudson' )
);
$row2->addChild(
	"header_light_icons_color",
	$header_light_icons_color
);

$header_light_hover_icons_color = new HudsonEdgeField(
	"colorsimple",
	"header_light_hover_icons_color",
	"",
	esc_html__( "Light Menu Icon Hover Color", 'hudson' ),
	esc_html__( "Choose a hover color for Header Light icons", 'hudson' )
);
$row2->addChild(
	"header_light_hover_icons_color",
	$header_light_hover_icons_color
);

$row3 = new HudsonEdgeRow( true );
$group1->addChild(
	"row3",
	$row3
);

$header_dark_icons_color = new HudsonEdgeField(
	"colorsimple",
	"header_dark_icons_color",
	"",
	esc_html__( "Dark Menu Icon Color", 'hudson' ),
	esc_html__( "Choose a color for Header Light icons", 'hudson' )
);
$row3->addChild(
	"header_dark_icons_color",
	$header_dark_icons_color
);

$header_dark_hover_icons_color = new HudsonEdgeField(
	"colorsimple",
	"header_dark_hover_icons_color",
	"",
	esc_html__( "Dark Menu Icon Hover Color", 'hudson' ),
	esc_html__( "Choose a hover color for Header Light icons", 'hudson' )
);
$row3->addChild(
	"header_dark_hover_icons_color",
	$header_dark_hover_icons_color
);

$header_buttons_font_size = new HudsonEdgeField(
	"text",
	"header_buttons_font_size",
	"",
	esc_html__( "Side Area Icon/ Search Icon Size", 'hudson' ),
	esc_html__( "Choose a size for Side Area / Search icons (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$panel9->addChild(
	"header_buttons_font_size",
	$header_buttons_font_size
);

$header_buttons_size = new HudsonEdgeField(
	"select",
	"header_buttons_size",
	"normal",
	esc_html__( "Side Menu Icon / Fullscreen Menu Icon Size", 'hudson' ),
	esc_html__( "Choose predefined size for Side Area / Fullscreen Menu icons", 'hudson' ),
	array(
		"normal" => esc_html__( "Normal", 'hudson' ),
		"medium" => esc_html__( "Medium", 'hudson' ),
		"large" => esc_html__( "Large", 'hudson' )
	)
);
$panel9->addChild(
	"header_buttons_size",
	$header_buttons_size
);

$group3 = new HudsonEdgeGroup(
	esc_html__( "Mobile Header Icons Color", 'hudson' ),
	esc_html__( "Choose color for mobile header icons (search icon, fullscreen menu icon and side area icon)", 'hudson' )
);
$panel9->addChild(
	"group3",
	$group3
);

$row1 = new HudsonEdgeRow( true );
$group3->addChild(
	"row1",
	$row1
);

$mobile_button_color = new HudsonEdgeField(
	"colorsimple",
	"mobile_button_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	esc_html__( "Choose a color for mobile menu icon", 'hudson' )
);
$row1->addChild(
	"mobile_button_color",
	$mobile_button_color
);

$mobile_button_color_hover = new HudsonEdgeField(
	"colorsimple",
	"mobile_button_color_hover",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	esc_html__( "Choose a hover color for mobile menu icon", 'hudson' )
);
$row1->addChild(
	"mobile_button_color_hover",
	$mobile_button_color_hover
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Fullscreen Menu Icon Background", 'hudson' ),
	esc_html__( "Define background for fullscreen menu icon in header", 'hudson' )
);
$panel9->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow( true );
$group2->addChild(
	"row1",
	$row1
);

$header_buttons_fullscreen_button_background = new HudsonEdgeField(
	"colorsimple",
	"header_buttons_fullscreen_button_background",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "Choose a background color for Fullscreen Menu icon", 'hudson' )
);
$row1->addChild(
	"header_buttons_fullscreen_button_background",
	$header_buttons_fullscreen_button_background
);

$header_buttons_fullscreen_button_background_hover = new HudsonEdgeField(
	"colorsimple",
	"header_buttons_fullscreen_button_background_hover",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "Choose a background hover color for Fullscreen Menu icon", 'hudson' )
);
$row1->addChild(
	"header_buttons_fullscreen_button_background_hover",
	$header_buttons_fullscreen_button_background_hover
);
// WPML Language Selector
if ( hudson_edge_is_wpml_installed() ) {
	
	$panel_lang_selector = new HudsonEdgePanel(
		esc_html__( "Language Selector", 'hudson' ),
		"lang_selector_panel"
	);
	$headerandfooterPage->addChild(
		"panel_lang_selector",
		$panel_lang_selector
	);
	
	$wpml_first_level_background_color = new HudsonEdgeField(
		"color",
		"wpml_first_level_background_color",
		"",
		esc_html__( "Background Color for First Level", 'hudson' ),
		esc_html__( "Choose a background color for first level element", 'hudson' )
	);
	$panel_lang_selector->addChild(
		"wpml_first_level_background_color",
		$wpml_first_level_background_color
	);
	
	// First Level Menu
	
	$group1 = new HudsonEdgeGroup(
		"1st Level Menu Style",
		esc_html__( "Define styles for first menu level ", 'hudson' )
	);
	$panel_lang_selector->addChild(
		"group1",
		$group1
	);
	
	$row1 = new HudsonEdgeRow();
	$group1->addChild(
		"row1",
		$row1
	);
	
	$wpml_first_level_menu_color = new HudsonEdgeField(
		"colorsimple",
		"wpml_first_level_menu_color",
		"",
		esc_html__( "Text Color", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row1->addChild(
		"wpml_first_level_menu_color",
		$wpml_first_level_menu_color
	);
	
	$wpml_first_level_menu_color_hover = new HudsonEdgeField(
		"colorsimple",
		"wpml_first_level_menu_color_hover",
		"",
		esc_html__( "Hover Color", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row1->addChild(
		"wpml_first_level_menu_color_hover",
		$wpml_first_level_menu_color_hover
	);
	
	$wpml_first_level_menu_google_fonts = new HudsonEdgeField(
		"fontsimple",
		"wpml_first_level_menu_google_fonts",
		"-1",
		esc_html__( "Font Family", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row1->addChild(
		"wpml_first_level_menu_google_fonts",
		$wpml_first_level_menu_google_fonts
	);
	
	$wpml_first_level_menu_fontsize = new HudsonEdgeField(
		"textsimple",
		"wpml_first_level_menu_fontsize",
		"",
		esc_html__( "Font Size (px)", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row1->addChild(
		"wpml_first_level_menu_fontsize",
		$wpml_first_level_menu_fontsize
	);
	
	$row2 = new HudsonEdgeRow( true );
	$group1->addChild(
		"row2",
		$row2
	);
	
	$wpml_first_level_menu_texttransform = new HudsonEdgeField(
		"selectblanksimple",
		"wpml_first_level_menu_texttransform",
		"",
		esc_html__( "Text Transform", 'hudson' ),
		esc_html__( "This is some description", 'hudson' ),
		hudson_edge_return_options_texttransform()
	);
	$row2->addChild(
		"wpml_first_level_menu_texttransform",
		$wpml_first_level_menu_texttransform
	);
	
	$wpml_first_level_menu_fontstyle = new HudsonEdgeField(
		"selectblanksimple",
		"wpml_first_level_menu_fontstyle",
		"",
		esc_html__( "Font Style", 'hudson' ),
		esc_html__( "This is some description", 'hudson' ),
		hudson_edge_return_options_fontstyle()
	);
	$row2->addChild(
		"wpml_first_level_menu_fontstyle",
		$wpml_first_level_menu_fontstyle
	);
	
	$wpml_first_level_menu_fontweight = new HudsonEdgeField(
		"selectblanksimple",
		"wpml_first_level_menu_fontweight",
		"",
		esc_html__( "Font Weight", 'hudson' ),
		esc_html__( "This is some description", 'hudson' ),
		hudson_edge_return_options_fontweight()
	);
	$row2->addChild(
		"wpml_first_level_menu_fontweight",
		$wpml_first_level_menu_fontweight
	);
	
	$wpml_first_level_menu_letterspacing = new HudsonEdgeField(
		"textsimple",
		"wpml_first_level_menu_letterspacing",
		"",
		esc_html__( "Letter Spacing (px)", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row2->addChild(
		"wpml_first_level_menu_letterspacing",
		$wpml_first_level_menu_letterspacing
	);
	
	$group2 = new HudsonEdgeGroup(
		"2nd Level Menu Style",
		esc_html__( "Define styles for second menu level ", 'hudson' )
	);
	$panel_lang_selector->addChild(
		"group2",
		$group2
	);
	
	$row1 = new HudsonEdgeRow();
	$group2->addChild(
		"row1",
		$row1
	);
	
	$wpml_second_level_menu_color = new HudsonEdgeField(
		"colorsimple",
		"wpml_second_level_menu_color",
		"",
		esc_html__( "Text Color", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row1->addChild(
		"wpml_second_level_menu_color",
		$wpml_second_level_menu_color
	);
	
	$wpml_second_level_menu_color_hover = new HudsonEdgeField(
		"colorsimple",
		"wpml_second_level_menu_color_hover",
		"",
		esc_html__( "Hover Color", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row1->addChild(
		"wpml_second_level_menu_color_hover",
		$wpml_second_level_menu_color_hover
	);
	
	$wpml_second_level_menu_google_fonts = new HudsonEdgeField(
		"fontsimple",
		"wpml_second_level_menu_google_fonts",
		"-1",
		esc_html__( "Font Family", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row1->addChild(
		"wpml_second_level_menu_google_fonts",
		$wpml_second_level_menu_google_fonts
	);
	
	$wpml_second_level_menu_fontsize = new HudsonEdgeField(
		"textsimple",
		"wpml_second_level_menu_fontsize",
		"",
		esc_html__( "Font Size (px)", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row1->addChild(
		"wpml_second_level_menu_fontsize",
		$wpml_second_level_menu_fontsize
	);
	
	$row2 = new HudsonEdgeRow( true );
	$group2->addChild(
		"row2",
		$row2
	);
	$wpml_second_level_menu_texttransform = new HudsonEdgeField(
		"selectblanksimple",
		"wpml_second_level_menu_texttransform",
		"",
		esc_html__( "Text Transform", 'hudson' ),
		esc_html__( "This is some description", 'hudson' ),
		hudson_edge_return_options_texttransform()
	);
	$row2->addChild(
		"wpml_second_level_menu_texttransform",
		$wpml_second_level_menu_texttransform
	);
	
	$wpml_second_level_menu_fontstyle = new HudsonEdgeField(
		"selectblanksimple",
		"wpml_second_level_menu_fontstyle",
		"",
		esc_html__( "Font Style", 'hudson' ),
		esc_html__( "This is some description", 'hudson' ),
		hudson_edge_return_options_fontstyle()
	);
	$row2->addChild(
		"wpml_second_level_menu_fontstyle",
		$wpml_second_level_menu_fontstyle
	);
	
	$wpml_second_level_menu_fontweight = new HudsonEdgeField(
		"selectblanksimple",
		"wpml_second_level_menu_fontweight",
		"",
		esc_html__( "Font Weight", 'hudson' ),
		esc_html__( "This is some description", 'hudson' ),
		hudson_edge_return_options_fontweight()
	);
	$row2->addChild(
		"wpml_second_level_menu_fontweight",
		$wpml_second_level_menu_fontweight
	);
	
	$wpml_second_level_menu_letterspacing = new HudsonEdgeField(
		"textsimple",
		"wpml_second_level_menu_letterspacing",
		"",
		esc_html__( "Letter Spacing (px)", 'hudson' ),
		esc_html__( "This is some description", 'hudson' )
	);
	$row2->addChild(
		"wpml_second_level_menu_letterspacing",
		$wpml_second_level_menu_letterspacing
	);
	
	$lang_items_padding = new HudsonEdgeField(
		'text',
		'header_bottom_lang_items_padding',
		'',
		esc_html__( 'Left / Right Spacing Between Languages in List (px)', 'hudson' ),
		esc_html__( 'Set spacing between languages when horizontal language switcher is added to main menu', 'hudson' ),
		array(),
		array( "col_width" => 3 )
	);
	$panel_lang_selector->addChild(
		'header_bottom_lang_items_padding',
		$lang_items_padding
	);
	
}	
	
